const id = "a"+Date.now()+"br"+Math.round(Math.random()*1000)
var document = globalThis.document||this.document;
var window = globalThis.window||this.window
const types = {
    isInvisibleWidget: false,
    type: "FLASH_WIDGET",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "Flash播放框控件",
    version: "1.0.0",
    isGlobalWidget: false,
    properties: [
      {
        key: '__width',
        label: '宽度',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__height',
        label: '高度',
        valueType: 'number',
        defaultValue: 150,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },{
        key:"scale",
        label:"大小",
        valueType:"number",
        defaultValue:50,
        unit:"%"
      },{
        key:"bg",
        label:"背景颜色",
        valueType:"color",
        defaultValue:"#666666",
      }
    ],
    methods: [{
        key:"loadSWF",
        label:"加载SWF文件",
        params:[
            {
                key:"url",
                label:"链接",
                valueType:"string",
                defaultValue:"https://ruffle.rs/assets/logo-anim.swf"
            }
        ]
    },{
        key:"load",
        label:"打开本地文件",
        params:[]
    }],
    events: [{
        key:"click",
        label:"被点击",
        params:[]
    },{
        key:"pointermove",
        label:"在控件上移动鼠标",
        params:[]
    },{
        key:"up",
        label:"松开鼠标",
        params:[]
    }],
  };
  
  class Widget extends VisibleWidget {
    domElement
    constructor(props) {
      super(props);
      this.__width = props.__width;
      this.__height = props.__height;
      this.scale = props.scale;
      this.bg = props.bg;
      this.ready = false
     var a  = document.createElement("script");
     a.src = "https://unpkg.com/@ruffle-rs/ruffle@0.1.0-nightly.2023.7.20/ruffle.js";
     document.body.appendChild(a)
     var  b = setInterval(e =>{
        if(window.RufflePlayer&&document.getElementById(id)){
            window.clearInterval(b)
           const domElement = window.RufflePlayer.sources.local.createPlayer()
           document.getElementById(id).appendChild(domElement)
           this.domElement = domElement
            this.ready = true
        }
     })
    }
    render(){
      return(<div id={id} style={{width:this.__width,height:this.__height,transform:`scale(${this.scale/100})`,backgroundColor:this.bg}} onClick={
       ()=>{this.emit("click")}
      } onPointerMove={()=>{this.emit("pointermove")}} onPointerUp={()=>{this.emit("up")}}></div>)
    }

    loadSWF(url){
        if(!this.ready){return}
       this.domElement.load(url)
    }

    load(){
        if(!this.ready){return}
        var a = document.createElement('input');
        a.type = "file";
        a.accept = ".swf"
        a.onchange = () =>{
            if(!a.files[0].name.includes(".swf")){
                window.alert("导入文件无效")
            }
            this.domElement.load(URL.createObjectURL(a.files[0]))
        }
        a.click()
    }
    
  }
  
  exports.types = types;
  exports.widget = Widget;
  