var document = globalThis.document
const types = {
    isInvisibleWidget: true,
    type: "HTML_ADDONS_GEN_WIDGET",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "HTML元素生成控件",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [{
        key:"br",
        label:"生成元素圆角",
        valueType:"number",
        defaultValue:5,
        unit:"像素"
    },{
        key:"gen",
        label:"媒体自适应",
        valueType:"string",
        defaultValue:"contain",
        dropdown:[
            {label:"保持宽高",value:"contain"},
            {label:"裁剪",value:"cover"},
            {label:"拉伸填充",value:"fill"}
        ]
    },{
        key:"cl",
        label:"'定义文本'的颜色",
        valueType:"color",
        defaultValue:"#000000"
    }],
    methods: [{
        key:"vid",
        label:"生成视/音频元素",
        valueType:"string",
        params:[{
            key:"controls",
            label:"显示控制台",
            valueType:"boolean",
            defaultValue:false
        },{
            key:"loop",
            label:"循环",
            valueType:"boolean",
            defaultValue:false
        },{
            key:"mute",
            label:"静音",
            valueType:"boolean",
            defaultValue:false
        },{
            key:"auto",
            label:"自动播放",
            valueType:"boolean",
            defaultValue:true
        },{
            key:"src",
            label:"视/音频源",
            valueType:'string',
            defaultValue:""
        },{
            key:"poster",
            label:"封面图",
            valueType:"string",
            defaultValue:""
        }],
        blockOptions:{
            inputsInline:false,
            line:"媒体"
        }
    },{
        key:"img",
        label:"生成图像",
        valueType:"string",
        params:[{
            key:"src",
            label:"图片源",
            valueType:"string",
            defaultValue:""
        },{
            key:"width",
            label:"宽度",
            valueType:"number",
            defaultValue:100
        },{
            key:"height",
            label:"高度",
            valueType:"number",
            defaultValue:80
        },{
            key:"no",
            label:"无图时显示文字",
            valueType:"string",
            defaultValue:"图片描述..."
        }],
        blockOptions:{
            inputsInline:false
        }
    },{
        key:"anc",
        label:"生成超链接",
        valueType:"string",
        params:[{
            key:"text",
            label:"文本内容",
            valueType:"string",
            defaultValue:""
        },{
            key:"href",
            label:"访问链接",
            valueType:"string",
            defaultValue:"" 
        },{
            key:"open",
            label:"打开新窗口",
            valueType:"boolean",
            defaultValue:true,
        }],
        blockOptions:{
            line:"文本扩展"
        }
    },{
        key:"b",
        label:"定义文本",
        valueType:"string",
        params:[
            {
                key:"bold",
                label:"粗细值(1-1000)",
                valueType:"number",
                defaultValue:500
            },{
                key:"italic",
                label:"斜体",
                valueType:"boolean",
                defaultValue:false
            },{
                key:"underline",
                label:"下划线",
                valueType:"boolean",
                defaultValue:false
            },{
                key:"line",
                label:"删除线",
                valueType:"boolean",
                defaultValue:false
            },{
                key:"style",
                label:"线条类型",
                valueType:"string",
                defaultValue:"solid",
                dropdown:[
                    {label:"虚线",value:"dashed"},
                    {label:"单线",value:"solid"},
                    {label:"波浪线",value:"wavy"},
                    {label:"双线",value:"double"}
                ]
            },{
                key:"space",
                label:"文本间隙",
                valueType:"number",
                defaultValue:2
            },{
                key:"size",
                label:"文本大小",
                valueType:"number",
                defaultValue:14
            },{
                key:"content",
                label:"文本内容",
                valueType:"string",
                defaultValue:""
            }
        ],
        blockOptions:{
            inputsInline:false
        }
    },{
        key:"brs",
        label:"生成HTML换行符",
        valueType:"string",
        params:[]
    },{
        key:"sub",
        label:"生成下标",
        valueType:"string",
        params:[{
            key:"c",
            label:"文本",
            valueType:"string",
            defaultValue:""
        }]
    },{
        key:"det",
        label:"生成详细信息展开控件",
        valueType:"string",
        params:[{
            key:"c",
            label:"标签文本",
            valueType:"string",
            defaultValue:""
        },{
            key:"a",
            label:"展示文本",
            valueType:"string",
            defaultValue:""
        }]
    },{
   key:"setBGImage",
   label:"设置[聊天框_轻蓝]背景图像",
   params:[
    {
        key:"img",
        label:"图像链接",
        valueType:"string",
        defaultValue:""
    }
   ],
   blockOptions:{
    line:"联动功能"
   }
    },{
        key:"setPop",
        label:"设置自身气泡",
        params:[
            {
                key:"img",
                label:"图像链接",
                valueType:"string",
                defaultValue:""
            },{
                key:"bg",
                label:"微透明",
                valueType:"boolean",
                defaultValue:false
            }
           ]
    }
],
    events: [],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        this.br = props.br;
        this.gen = props.gen;
        this.cl = props.cl
    }

    vid(controls,loop,mute,auto,src,poster){
      var a = document.createElement('video');
      a.controls = controls;
      a.style.width = "100%";
      a.style.height = "100%"
      a.muted = mute;
      a.poster = poster
      a.loop = loop;a.autoplay = auto
      a.src = src;
      a.style.borderRadius = this.br+'px';
      
      a.style.objectFit = this.gen
      return a.outerHTML
    }

    img(src,width,height,no){
        var a = new Image(width,height);
        a.src = src;
        a.alt = no;
        a.style.borderRadius = this.br+'px';
      a.style.objectFit = this.gen
        return a.outerHTML
    }
    
    anc(text,href,open){
        return `<a href="${href}" target="${open?"_blank":"_self"}" style="color:${this.cl}">${text}</a>`
    }

    b(bold,italic,underline,line,style,space,size,content){
        var a = document.createElement("span");
        a.style.color = this.cl;
        a.style.fontWeight = bold;
        a.style.fontStyle = italic?"italic":"";
        a.style.textDecoration = underline||line?(underline?"underline ":""+line?"line-through":""):"none";
        a.style.textDecorationStyle = underline||line?style:"";
        a.style.letterSpacing = space+"px";
        a.style.fontSize = size+"px";
        a.innerHTML = content
        return a.outerHTML
    }

    brs(){
        return `<br />`
    }

    sub(c){
        return `<sub>${c}</sub>`
    }

    det(c,a){
        return `<details>
        <summary>${c}</summary>
        ${a}
        </details>`
    }
    setBGImage(img){
        if(!document.getElementById("lite-chatbox")){return}
        document.getElementById("lite-chatbox").style.backgroundImage = `url(${img})`;
        document.getElementById("lite-chatbox").style.backgroundSize = "cover"
    }

    setPop(img,blur){
        document.head.innerHTML +=`
         <style>
         .cright > .content{
            background-image:url(${img}) !important;
            ${blur?`
            opacity:.7
            `:""}
         }
         </style>
        `
    }
}


exports.types = types;
exports.widget = Widget;
