/**
 * Copyright 2024年2月5日 ReducedRadius.
 * 虚拟机库链接请勿随意使用!
 * 本控件原理:
 * 使用名为V86虚拟机库然后加载并显示于一个分区(div)上;
 * 注意:此虚拟机效率较低,且达到Windows 7 及以上不可使用!
 * 这是作者明面上最后一个控件。
 */
var id  =crypto.randomUUID()+"rrvm";
var document = globalThis.document;
var window = globalThis;
function resolveURL(URL) {
    if (window.URL.startsWith('http://')) {
  return (window.URL.replace('http://','https://coco.codemao.cn/http-widget-proxy/http@SEP@'));} else if (URL.startsWith('https://')) {
  return (window.URL.replace('https://','https://coco.codemao.cn/http-widget-proxy/https@SEP@'));
}

}
const types = {
    isInvisibleWidget: false,
    type: "REDUCED_RADIUS_VM_WIDGET",
    icon: globalThis.atob("aHR0cHM6Ly9kYXNoZWRyYWRpdXMubmV0bGlmeS5hcHAvYmxvY2tseV9odG1sX3poX0NOL2ljb24ucG5n"),
    title: "虚拟机控件",
    version: "1.0.1",
    isGlobalWidget: false,
    properties: [{
        key: '__width',
        label: '宽度',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__height',
        label: '高度',
        valueType: 'number',
        defaultValue: 150,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },{
        key:"b",
        label:"显存大小",
        valueType:"number",
        defaultValue:8,
        unit:"MB"
    },{
        key:"c",
        label:"CD映像链接",
        valueType:"string",
        defaultValue:""
    },{
        key:"d",
        label:"软盘映像链接",
        valueType:"string",
        defaultValue:""
    },{
        key:"e",
        label:"硬盘映像链接",
        valueType:"string",
        defaultValue:""
    },{
        key:"f",
        label:"无声运行",
        valueType:"boolean",
        defaultValue:false
    },{
        key:"g",
        label:"启用ACPI",
        valueType:"boolean",
        defaultValue:false
    },{
        key:"h",
        label:"启动顺序",
        valueType:"string",
        defaultValue:"123",
        dropdown:[
            {label:"CD在前",value:"123"},
            {label:"软盘在前",value:"321"},
            {label:"硬盘在前",value:"132"}
        ]
    },{
        key:"memory",
        label:"内存",
        valueType:"number",
        defaultValue:128,
        unit:"MB"
    },{
        key:"hdb",
        label:'第二硬盘映像链接',
        valueType:"string",
        defaultValue:""
    },{
        key:"fdb",
        label:"第二软盘映像链接",
        valueType:"string",
        defaultValue:""
    },{
        key:"bg",
        label:'未启动时背景颜色',
        valueType:"color",
        defaultValue:"#ffffff"
    }],
    methods: [{
        key:"init",
        label:"启动虚拟机",
        params:[]
    },{
        key:"run",
        label:"继续运行",
        params:[]
    },{
        key:"stop",
        label:"暂停运行",
        params:[]
    },{
        key:"restart",
        label:"重启",
        params:[]
    },{
        key:"s",
        label:"正在运行?",
        params:[],
        valueType:"boolean"
    },{
        key:"getStatus",
        label:'尝试获取状态文件',
        params:[],
        valueType:"string"
    },{
        key:"setStatus",
        label:"用文件还原状态",
        params:[
            {key:"a",label:"链接",valueType:"string",defaultValue:""}
        ]
    },{
        key:"screen_go_fullscreen",
        label:"全屏预览",
        params:[]
    },{
        key:'opencd',
        label:"请求打开文件",
        params:[{
            key:"type",
            label:'打开类型',
            valueType:"string",
            dropdown:[
                {label:'CD-ROM映像',value:".iso"},
                {label:'软盘映像',value:".flp,.img"},
                {label:'硬盘映像',value:".img"},
                {label:'纯文本',value:'.txt'}
            ]
        }]
    },{
        key:"lock",
        label:"锁定鼠标",
        params:[]
    },{
        key:"emu",
        label:'模拟CPU重启',
        params:[]
    }],
    events: [{
        key:"url",
        label:"打开文件成功",
        params:[{key:"q",label:"链接",valueType:"string"}]
    },{
        key:"click",
        label:"被点击",
        params:[]
    },{
        key:"move",
        label:"鼠标移动",
        params:[{
            key:"x",
            label:"横向移动幅度",
            valueType:"number"
        },{
            key:"y",
            label:"纵向移动幅度",
            valueType:"number"
        }]
    }],
};

class Widget extends VisibleWidget {
    constructor(props) {
        super(props);
        var script = globalThis.document.createElement("script");
  script.src = "\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0064\u0061\u0073\u0068\u0065\u0064\u0072\u0061\u0064\u0069\u0075\u0073\u002e\u006e\u0065\u0074\u006c\u0069\u0066\u0079\u002e\u0061\u0070\u0070\u002f\u0076\u006d\u002f\u006c\u0069\u0062\u0076\u0038\u0036\u002e\u006a\u0073";
   globalThis.document.body.appendChild(script);
        this.instance = undefined;
        this.azz = props.memory;
        this.b = props.b;
        this.c=props.c,this.d = props.d,this.e = props.e;
        this.f = props.f;this.g= props.g;this.h = parseInt(props.h,16);
        this.hdb = props.hdb;
        this.bg = props.bg;
    }

    render(){
        return(<div id={id} style={{
            backgroundColor:this.bg,
            width:this.__width,
            height:this.__height
        }} onClick={()=>this.emit("click")} onMouseMove={()=>this.emit("move",event.movementX,event.movementY)}>
            <div style={{
                "white-space": "pre",
                "font": "14px monospace",
                "line-height": "14px"
                }}></div>
            <canvas ></canvas></div>)
    }
    lock(){if(this.instance)this.instance.lock_mouse()}

    init(){
        if(globalThis.V86Starter){
            this.instance = new globalThis.V86Starter({
                autostart:true,
                bios:{
                    url:resolveURL("\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0064\u0061\u0073\u0068\u0065\u0064\u0072\u0061\u0064\u0069\u0075\u0073\u002e\u006e\u0065\u0074\u006c\u0069\u0066\u0079\u002e\u0061\u0070\u0070\u002f\u0076\u006d\u002f\u0062\u0069\u006f\u0073\u002f\u0073\u0065\u0061\u0062\u0069\u006f\u0073\u002e\u0062\u0069\u006e")
                },
                vga_bios:{
                   url:resolveURL("\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0064\u0061\u0073\u0068\u0065\u0064\u0072\u0061\u0064\u0069\u0075\u0073\u002e\u006e\u0065\u0074\u006c\u0069\u0066\u0079\u002e\u0061\u0070\u0070\u002f\u0076\u006d\u002f\u0062\u0069\u006f\u0073\u002f\u0076\u0067\u0061\u0062\u0069\u006f\u0073\u002e\u0062\u0069\u006e")
                },
                cdrom:{
                  url:this.c?resolveURL(this.c):undefined
                },
                fda:{
                    url:this.d?resolveURL(this.d):undefined
                },
                fdb:{
                    url:this.fdb?resolveURL(this.fdb):undefined
                },
                hda:{
                    url:this.e?resolveURL(this.e):undefined
                },
                hdb:{
                    url:this.hdb?resolveURL(this.hdb):undefined
                },
                memory_size:this.azz*1024*1024,
                vga_memory_size:this.b*1024*1024,
                acpi:Boolean(this.g),
                disable_speaker:Boolean(this.f),
                boot_order:this.h,
                screen_container:globalThis.document.getElementById(id),
                wasm_path:resolveURL("\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0064\u0061\u0073\u0068\u0065\u0064\u0072\u0061\u0064\u0069\u0075\u0073\u002e\u006e\u0065\u0074\u006c\u0069\u0066\u0079\u002e\u0061\u0070\u0070\u002f\u0076\u006d\u002f\u0076\u0038\u0036\u002e\u0077\u0061\u0073\u006d")
            })
        }else{
            setTimeout(e =>{
                 this.init()
            },999)
        }
    }

    run(){
        if(this.instance)this.instance.run()
    }
    stop(){if(this.instance)this.instance.stop()}
    restart(){if(this.instance)this.instance.restart()}
    s(){if(this.instance)return this.instance.cpu_is_running}
    async getStatus(){if(this.instance){
        var file = await this.instance.save_state();
        var blob = new Blob([file]);
        return globalThis.URL.createObjectURL(blob);
    }}
 async setStatus(a){
         try{
          const  b = await globalThis.fetch(a);
          if(this.instance)this.instance.restore_status(await b.arrayBuffer())
         }catch(e){
            this.widgetError("设置状态时出错了,"+e.message)
         }
    }
    screen_go_fullscreen(){
        if(document.getElementById(id)){
            document.getElementById(id).requestFullscreen({navigationUI:"hide"})
        }
    }
    opencd(type){
        var input = globalThis.document.createElement("input");
        input.type = "file";
        input.accept = type;
        input.multiple = false
        input.onchange = () =>{
             var files = input.files[0];
            this.emit("url",window.URL.createObjectURL(files))
        }
        input.click()
    }
    emu(){
        this.instance?this.instance.v86.cpu.reset_cpu():0
    }

}

types["properties"].forEach(e =>{
    if(!e.label.includes("链接")){
    e.blockOptions = {
        generateBlock:false
    }
}
})


exports.types = types;
exports.widget = Widget;
