const types = {
  isInvisibleWidget: false,
  type: "SWEET_LOADINGER",
  icon: "https://creation.codemao.cn/716/appcraft/IMAGE_neVnlWSqB_1670835351907.png",
  title: "优质圆形加载条",
  version: "1.0.0",
  isGlobalWidget: false,
  properties: [
    {
      key: '__width',
      label: '宽度',
      valueType: 'number',
      defaultValue: 200,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__height',
      label: '高度',
      valueType: 'number',
      defaultValue: 150,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__size',
      label: '',
      valueType: 'number',
      defaultValue: 0,
      readonly: true,
      blockOptions: {
        setter: {
          keys: ['__height', '__width'],
        },
        getter: {
          keys: ['__height', '__width'],
        },
      },
    },
  ],
  methods: [],
  events: [],
};

class Widget extends VisibleWidget {
  constructor(props) {
    super(props);
    this.__width = props.__width;
    this.__height = props.__height;
    this.width=props.width;
  this.num=props.num;
  this.radius=props.radius;
  this.bgcolor=props.bgcolor;
  this.loadcolor=props.loadcolor;
  this.content=props.content;
  this.weight=props.weight;
  this.right=props.right;
  this.up=props.up;
  this.Fontcolor=props.Fontcolor;
  this.loadcoloro=props.loadcoloro;
  this.loadcolort=props.loadcolort;

  }
  render() {
    return(
      React.createElement("div", {  onClick: this.onClick.bind(this),
      onChange: this.onChange.bind(this),
    }, [React.createElement("svg", {}, [React.createElement("linearGradient", {  id: 'grad1',
          x1: '0%',
          x2: '100%',
          y1: '0%',
          y2: '0%',
        }, [React.createElement("stop", {  offset: '2%',
            style: {  stopColor: (this.loadcoloro),
            },
          }, []),
          React.createElement("stop", {  offset: '100%',
            style: {  stopColor: (this.loadcolort),
            },
          }, []),]),
        React.createElement("circle", {  r: (this.radius),
          cx: '80',
          cy: '60',
          strokeLinecap: 'round',
          strokeWidth: (this.width),
          style: {  stroke: '#999999',
            fill: '#ffffff',
            strokeDashoffset: '2px',
            strokeDasharray: '2px',
            transform: 'rotate(-90deg)',
            transformOrigin: '26.5% 39%',
            transition: 'all 1s ease',
          },
        }, []),
        React.createElement("circle", {  r: (this.radius),
          cx: '80',
          cy: '60',
          strokeLinecap: 'round',
          strokeWidth: (this.width),
          style: {  stroke: 'url(#grad1)',
            fill: (this.bgcolor),
            strokeDasharray: '295.31',
            strokeDashoffset: (295.31 - (this.num) * 2.9531),
            transform: 'rotate(-90deg)',
            transformOrigin: '26.5% 39%',
            transition: 'all 1s ease',
          },
        }, []),]),
      React.createElement("span", {  style: {  position: 'absolute',
          left: (this.right),
          bottom: (this.up),
          transition: 'all 1s ease',
          fontSize: (this.weight),
          color: (this.Fontcolor),
        },
      }, [(this.content)]),])
  );

  }
}

types['properties'].push({
    key: 'width',
    label: '边缘宽度',
    valueType: 'number',
    defaultValue: 7,

})

types['properties'].push({
    key: 'num',
    label: '数值(百分比)',
    valueType: 'number',
    defaultValue: 30,

})

types['properties'].push({
    key: 'radius',
    label: '半径',
    valueType: 'number',
    defaultValue: 45,

})

types['properties'].push({
    key: 'bgcolor',
    label: '内部加载背景颜色',
    valueType: 'color',
    defaultValue: '#ffffff',

})

types['properties'].push({
    key: 'loadcoloro',
    label: '加载条颜色一',
    valueType: 'color',
    defaultValue: '#33ff33',

})

types['properties'].push({
    key: 'loadcolort',
    label: '加载条颜色二',
    valueType: 'color',
    defaultValue: '#ffcc33',

})

types['properties'].push({
    key: 'Fontcolor',
    label: '文案颜色',
    valueType: 'color',
    defaultValue: '#33cc00',

})

types['properties'].push({
    key: 'content',
    label: '加载条内部文案',
    valueType: 'string',
    defaultValue: '20%',

})

types['properties'].push({
    key: 'weight',
    label: '文案粗细',
    valueType: 'number',
    defaultValue: 15,

})

types['properties'].push({
    key: 'right',
    label: '将文案向右移',
    valueType: 'number',
    defaultValue: 78,

})

types['properties'].push({
    key: 'up',
    label: '将文案向上移',
    valueType: 'number',
    defaultValue: 72,

})

types['methods'].push({
    key: 'BINDER',
    label: '将进度与内容绑定（建议重复使用）',
    params: [],


})
Widget.prototype.BINDER = function () {
      this.setProps({ 'content': (String(this.num) + '%') });

}
types['events'].push({
    key: 'onClick',
    label: '被点击',
    params: [],

})
Widget.prototype.onClick = function (event) {
      this.emit("onClick");
}

types['events'].push({
    key: 'onChange',
    label: '任意属性被更改',
    params: [
      {
          key: 'OBJ',
          label: '改变内容',
          valueType: 'string',
      },],

})
Widget.prototype.onChange = function (event) {
      this.emit("onChange"  ,event.target.value);
}

exports.types = types;
exports.widget = Widget;
