//20240728:添加滤镜
var id = `${Math.floor(Math.random()*1e15)}ReducedRadius`;
var document = globalThis.document;
var navigator = globalThis.navigator;
var window = globalThis;
const types = {
    isInvisibleWidget: false,
    type: "CAMERA_REALTIME_WIDGET",
    icon: "icon-widget-camera",
    title: "实时画面",
    version: "1.0.3",
    author:"ReducedRadius",
    docs:{url:"https://reducedradius.netlify.app/widget"},
    isGlobalWidget: false,
    properties: [{
        key: '__width',
        label: '播放器宽',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__height',
        label: '播放器高',
        valueType: 'number',
        defaultValue: 150,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },{
        key:"scale",
        label:"播放器大小",
        valueType:"number",
        defaultValue:100,
        unit:"%"
      },{
        key:"rotate",
        label:"播放器旋转",
        valueType:"number",
        defaultValue:0,
        unit:"度"
      },{
        key:"br",
        label:"播放器圆角",
        valueType:"number",
        defaultValue:3,
      },{
        key:"fi",
        label:"拍照滤镜参数",
        valueType:"string",
        defaultValue:"",
        dropdown:[
            {label:"复古",value:"sepia()"},
            {label:"反色",value:"invert(1)"},
            {label:"半透明",value:"opacity(0.5)"},
            {label:'高亮度',value:"brightness(1.5)"},
            {label:"低亮度",value:"brightness(0.5)"},
            {label:'高对比度',value:"contrast(1.5)"},
            {label:'微糊',value:"blur(2px)"},
            {label:"黑白",value:"grayscale(1)"},
            {label:"变色",value:'hue-rotate(90deg)'},
            {label:"无",value:"none"}
        ]
      }],
    methods: [{
        key:"shot",
        label:"打开摄像头",
        params:[{
            key:"frame",
            label:"视频流帧率",
            valueType:"number",
            defaultValue:45
        },{
            key:"audio",
            label:'启用音频',
            valueType:"boolean",
            defaultValue:true
        },{
           key:"width",
           label:"截取视频高",
           valueType:"number",
           defaultValue:1920
        },{
            key:"height",
            label:"截取视频宽",
            valueType:"number",
            defaultValue:1080
         },{
            key:"sample",
            label:"音频采样率",
            valueType:"number",
            defaultValue:44100
         },{
            key:"noise",
            label:"自动减噪",
            valueType:"boolean",
            defaultValue:false
         },{
            key:"echo",
            label:"智能消除回音",
            valueType:"boolean",
            defaultValue:true
         },{
            key:"dir",
            label:"摄像头朝向",
            valueType:"string",
            defaultValue:"user",
            dropdown:[
                {label:"使用者",value:'user'},
                {label:"环境",value:"environment"},
                {label:"使用者且左侧偏移",value:"left"},
                {label:"使用者且右侧偏移",value:"right"}
            ]
         },{
            key:"auto",
            label:"自动音频增益",
            valueType:"boolean",
            defaultValue:false
         }],
         blockOptions:{
            inputsInline:false,
            line:"初始化"
         }
    },{
        key:"shots",
        label:"拍照并返回图片(永久链接)",
        valueType:"string",
        params:[{
            key:"flash",
            label:"闪光灯",
            valueType:"string",
            defaultValue:"auto",
            dropdown:[
                {label:'自动',value:"auto"},
                {label:'打开',value:"flash"},
                {label:"关闭",value:"off"}
            ]
        },{
            key:"red",
            label:"防“红眼”",
            valueType:"boolean",
            defaultValue:false
        }],
        blockOptions:{
            line:"拍照(需要打开摄像头)"
        }
    },{
        key:"pic",
        label:"拍照并返回图片(临时链接)",
        valueType:"string",
        params:[{
            key:"flash",
            label:"闪光灯",
            valueType:"string",
            defaultValue:"auto",
            dropdown:[
                {label:'自动',value:"auto"},
                {label:'打开',value:"flash"},
                {label:"关闭",value:"off"}
            ]
        },{
            key:"red",
            label:"防“红眼”",
            valueType:"boolean",
            defaultValue:false
        }]
    },{
        key:"filter",
        label:"使用滤镜拍照并获得图片(永久链接)",
        valueType:"string",
        params:[]
    },{
        key:"close",
        label:'关闭摄像头',
        params:[],
    },{
        key:"record",
        label:"开始录制视频",
        params:[{
            key:"codecs",
            label:"视频压缩",
            valueType:"string",
            dropdown:[
                {label:'普通webm视频',value:'video/webm'},
                {label:"H264压缩",value:"video/webm;codecs=h264"},
                {label:'VP8压缩',value:"video/webm;codecs=vp8"},
                {label:"VP9压缩",value:"video/webm;codecs=vp9"},
                {label:"音频",value:"audio/webm"},
                {label:'自动选择',value:"auto"}
            ]
        }],
        blockOptions:{
            line:'录制'
        }
    },{
        key:"pause",
        label:'暂停录制视频',
        params:[]
    },{
        key:"resume",
        label:"恢复录制状态",
        params:[]
    },{
        key:"stop",
        label:'停止录制视频',
        params:[]
    },{
        key:"cut",
        label:'截取视频数据但保持录制',
        params:[]
    },{
        key:'getRecordTime',
        label:'获取当前录制时间(秒)',
        params:[],
        valueType:"number"
    },{
        key:"state",
        label:"是否在录制?",
        valueType:"boolean",
        params:[]
    },{
        key:"check",
        label:"检查设备是否支持录制?",
        valueType:"boolean",
        params:[]
    },{
        key:'mute',
        label:"设置播放静音",
        params:[{
            key:"a",
            label:"",
            valueType:"boolean",
            defaultValue:true
        }]
    }],
    events: [{
        key:"click",
        label:"播放器被点击",
        params:[]
    },{
        key:"dev",
        label:"用户接入或拔出媒体设备",
        params:[]
    },{
        key:'data',
        label:'生成录制文件完毕(包括截取)',
        params:[{
            key:"url",label:'永久链接',valueType:"string"
        },{
            key:"blob",label:'临时链接',valueType:"string"
        },{
            key:'size',label:"文件大小(MB)",valueType:"number"
        },{
            key:"stamp",label:"录制时长",valueType:"number"
        }]
    },{
        key:"err",
        label:"录制发生错误",
        params:[]
    }],
};

class Widget extends VisibleWidget {
    constructor(props) {
        super(props);
        this.stream = null;
        this.scale = props.scale
        this.__width = props.__width;
        this.rotate = props.rotate
    this.__height = props.__height;
    this.br =props.br;
    this.fi = props.fi;
    this.start = undefined;
    navigator.mediaDevices.ondevicechange = () =>this.emit("dev");
    this.widgetLog("欢迎使用ReducedRadius的控件!");
    
    }

    render(){
        return (<video id={id} autoplay style={{
            transform:`scale(${this.scale/100}) rotate(${this.rotate}deg)`,
            borderRadius:this.br+"px",
            objectFit:"cover",
            filter:this.fi,
        }} width={this.__width} height={this.__height} onClick={()=>{this.emit("click")}} onError={()=>{this.emit("err")}}></video>)
    }

 async  shot(frame,audio,width,height,sample = 44100,noise,echo,dir,auto){
    if(!document.getElementById(id)){
        setTimeout(e =>{this.shot(frame,audio,width,height,sample,noise,echo,dir,auto)},100)
        return;
    }
      this.stream = await navigator.mediaDevices.getUserMedia({
            video:{
                frameRate:frame,width,height,facingMode:dir
            },
            audio:audio?{
                echoCancellation:echo,
                noiseSuppression:noise,
                sampleRate:sample,
                autoGainControl:auto
            }:undefined
        })
        document.getElementById(id).srcObject = this.stream
        try{
        document.getElementById(id).play()
        }catch{
            this.widgetError("照相机成功打开,但是请多点击几次播放器,否则无法直接显示视频图像")
        }
    }
   async shots(flash,red){
        if(this.stream){
            var a = new ImageCapture(this.stream.getVideoTracks()[0])
         const blob = await  a.takePhoto({
                fillLightMode:flash,
                redEyeReduction:red
            })
            return await new Promise(resolve =>{
                var afl = new FileReader;
                afl.onload = e =>resolve(afl.result)
                afl.readAsDataURL(blob)
            })
        }
    }
 

    async pic(flash,red){
        if(this.stream){
            var a = new ImageCapture(this.stream.getVideoTracks()[0])
         const blob = await  a.takePhoto({
                fillLightMode:flash,
                redEyeReduction:red
            })
            return globalThis.URL.createObjectURL(blob)
        }
     }

    close(){
        if(this.stream)this.stream.getTracks().forEach(e =>e.stop())
    }

    record(codecs){
      if(this.stream){
        this.recorder = new MediaRecorder(this.stream,{
            mimeType:MediaRecorder.isTypeSupported(codecs)?codecs:undefined
        });
        this.start = Date.now()
        this.recorder.ondataavailable = async(e) =>{
              this.emit("data",await (function(blob){ 
                return new Promise(resolve =>{
                var afl = new FileReader;
                afl.onload = e =>resolve(afl.result)
                afl.readAsDataURL(blob)
            })})(e.data),
             URL.createObjectURL(e.data),
            (e.data.size/(1024*1024)).toFixed(2)
            ,e.timecode)
        }
        this.recorder.onerror = () =>this.emit("err")
        this.recorder.start()
      }
    }

    pause(){
        if(this.recorder && this.recorder.state === "recording"){
            this.recorder.pause()
        }
    }
    resume(){
        if(this.recorder && this.recorder.state === "paused"){
            this.recorder.resume()
        }
    }

    stop(){
        if(this.recorder && this.recorder.state === "recording"){
            this.recorder.stop()
            this.start = undefined
        }
    }

    cut(){
        if(this.recorder&&this.recorder.state === "recording"){
            this.recorder.requestData()
        }
    }
  
    getRecordTime(){
        return typeof this.start == "number"?(Date.now()-this.start)/1000:void 0
    }
    state(){
        return this.recorder.state == "recording"
    }
    check(){
        this.supports =  navigator.mediaDevices.getSupportedConstraints();
        return (window.ImageCapture&&this.supports.autoGainControl&&this.supports.frameRate&&this.supports.width&&window.MediaRecorder&&window.HTMLVideoElement&&window.URL.createObjectURL&&window.Promise&&window.BlobEvent)
    }

    mute(a){
        document.getElementById(id).muted = Boolean(a)
    }

   async filter(){
        if(!globalThis.ImageCapture){
            this.widgetError("您的系统不支持此功能")
        }else{
           const a = new ImageCapture(this.stream.getVideoTracks()[0]);
           var bit =  await a.grabFrame();
           var _c = document.createElement("canvas");
           _c.getContext("2d").filter = this.fi;
           _c.getContext("2d").drawImage(bit,0,0,_c.width,_c.height);
           return _c.toDataURL()
        }
    }

}

types["methods"].forEach(e =>{
    if(!e.blockOptions){
        e.blockOptions = {
            color:"#49bef8",
        }
    }else{
        e.blockOptions.color = "#49bef8"
    }
})

exports.types = types;
exports.widget = Widget;
