var document  = globalThis.document;
var id = Math.random()*100+Date.now()
const types = {
    isInvisibleWidget: true,
    type: "SCREEN_FILTER_WIDGET",
    icon: "https://ocean.codemao.cn/appcraft/resource/icon/%E5%9F%BA%E7%A1%80/%E6%98%BE%E7%A4%BA.svg",
    title: "屏幕滤镜控件",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [{
        key:"a",
        label:"错乱滤镜应用值",
        valueType:"number",
        defaultValue:5,
        blockOptions:{
            generateBlock:false
        }
    }],
    methods: [{
        key:"filterA",
        label:"打开蓝光滤镜",
        params:[]
    },{
        key:"filterB",
        label:"打开反色滤镜",
        params:[]
    },{
        key:"filterC",
        label:"打开像素合并滤镜",
        params:[]
    },{
        key:"blur",
        label:"设置高斯模糊",
        params:[{
            key:"size",
            label:'滤镜大小',
            valueType:"number",
            defaultValue:0.3
        }]
    },{
        key:"filterD",
        label:"颜色散射(偏蓝)滤镜",
        params:[]
    },{
        key:"filterE",
        label:"颜色散射(偏绿)滤镜",
        params:[]
    },{
        key:"filterF",
        label:"错乱滤镜",
        params:[]
    },{
        key:"filterG",
        label:"胶泥状滤镜",
        params:[]
    },{
        key:"close",
        label:"关闭滤镜",
        params:[],
    },{
        key:'create',
        label:"创建颜色混合滤镜并应用",
        params:[{
            key:'cl',
            label:"创建的颜色矩阵(20数,中间空格)",
            valueType:"string",
            defaultValue:`-1 0 0 0 -1
            0 -1 0 0 -1
            -0.1 1 -0.1 0 0
            0 -0.1 -0.2 1 0`
        }],
        blockOptions:{
            line:"高级自定义选项",
            inputsInline:false
        }
    },{
        key:"createCon",
        label:"创建像素混合滤镜并应用",
        params:[{
            key:'cl',
            label:"创建的颜色矩阵(9数,中间空格)",
            valueType:"string",
            defaultValue:`1 2 3 4 5 6 7 8 9`
        },{
            key:"w",
            label:"矩阵除数",
            valueType:'number',
            defaultValue:50
        },{
            key:"l",
            label:"透明通道是否应用?",
            valueType:"boolean",
            defaultValue:true
        },{
            key:"o",
            label:"矩阵数",
            valueType:"number",
            defaultValue:3
        }],
        blockOptions:{
            inputsInline:false
        }
    }],
    events: [],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
    setTimeout(e =>{
        document.body.innerHTML += `<svg id='${id}'>
        <filter id="blue">
         <feColorMatrix values="-1 0 0 0 -1
         0 -1 0 0 -1
         -.1 1 -.1 0 0
         0 -.1 -.2 1 0" in="SourceGraphic" type="matrix"/>
        </filter>
        <filter id="convo">
  <feConvolveMatrix order="3" kernelMatrix="1 -1  1 -1 -0.01 -1 1 -1 1"  result="convo">
  </feConvolveMatrix>
</filter>
<filter id="anag">
  <feFlood flood-opacity="1" flood-color="rgb(255,255,255)" result="flood"></feFlood>
  <feColorMatrix in="SourceGraphic" values="0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 -1 0 0 1 0 "></feColorMatrix>
  <feOffset dy="0" dx="8" result="offset1"></feOffset>
  <feBlend in2="flood" mode="multiply" result="blend1"></feBlend>
  <feColorMatrix in="SourceGraphic" values="0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 -1 0 1 0 "></feColorMatrix>
  <feBlend in2="blend1" mode="multiply" result="blend2"></feBlend>
  <feColorMatrix in="SourceGraphic" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 -1 1 0 "></feColorMatrix>
  <feBlend in2="blend2" mode="multiply"></feBlend>
</filter>
<filter id="vhs">
  <feFlood flood-opacity="1" flood-color="rgb(255,255,255)" result="flood"></feFlood>
  <feColorMatrix in="SourceGraphic" values="0 0 0 0 0 0 0 0 0 1 0 0 0 0 1 -1 0 0 1 0 ""></feColorMatrix>
  <feOffset dy="-1" dx="-3" result="offset1"></feOffset>
  <feBlend in2="flood" mode="multiply" result="blend1"></feBlend>
  <feColorMatrix in="SourceGraphic" values="0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 -1 0 1 0 "></feColorMatrix>
  <feOffset dy="2" dx="-1" result="offset2"></feOffset>
  <feBlend in2="blend1" mode="multiply" result="blend2"></feBlend>
  <feOffset dy="3" dx="-2" result="offset3"></feOffset>
  <feColorMatrix in="SourceGraphic" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 -1.5 1 0 "></feColorMatrix>
  <feBlend in2="offset3" mode="multiply"></feBlend>
</filter>
<filter id="disp">
  <feDisplacementMap scale="${props.a}" xChannelSelector="R"></feDisplacementMap>
</filter>
<filter id="k" style="color-interpolation-filters:sRGB;">
  <feGaussianBlur result="result10" stdDeviation="5"></feGaussianBlur>
  <feGaussianBlur in="SourceGraphic" result="result4" stdDeviation="1.5"></feGaussianBlur>
  <feBlend mode="darken" in2="result10"></feBlend>
  <feComposite operator="atop" in2="SourceGraphic" result="result5"></feComposite>
  <feColorMatrix type="saturate" values="0" result="result1" in="result5"></feColorMatrix>
  <feComponentTransfer result="component1" in="result1">
  <feFuncR type="table" tableValues="0 0.2 0.133333 0.3 0.4 0.333333 0.5 0.6 0.533333 0.7 0.8 0.733333 0.9 1 0.933333 1.1 1"></feFuncR>
  <feFuncG type="table" tableValues="0 0.2 0.133333 0.3 0.4 0.333333 0.5 0.6 0.533333 0.7 0.8 0.733333 0.9 1 0.933333 1.1 1"></feFuncG>
  <feFuncB type="table" tableValues="0 0.2 0.133333 0.3 0.4 0.333333 0.5 0.6 0.533333 0.7 0.8 0.733333 0.9 1 0.933333 1.1 1"></feFuncB>
  </feComponentTransfer>
  <feFlood flood-color="rgb(255,0,0)" result="result2"></feFlood>
  <feBlend in2="component1" mode="screen" result="result2" in="result2"></feBlend>
  <feBlend result="fbSourceGraphic" mode="multiply" in2="component1"></feBlend>
  <feColorMatrix result="result2" type="luminanceToAlpha" in="fbSourceGraphic"></feColorMatrix>
  <feDiffuseLighting lighting-color="#ffffff" in="result2" diffuseConstant="1" result="result1" surfaceScale="15">
  <feDistantLight azimuth="31" elevation="10"></feDistantLight>
  </feDiffuseLighting>
  <feSpecularLighting specularExponent="10" in="result2" result="result11" surfaceScale="-15">
  <feDistantLight azimuth="225" elevation="45"></feDistantLight>
  </feSpecularLighting>
  <feComposite operator="arithmetic" k2="0.5" k3="0.5" in2="result1" result="result12"></feComposite>
  <feComposite in="result12" in2="fbSourceGraphic" result="result9" operator="arithmetic" k2="1" k3="1"></feComposite>
  <feComposite in2="SourceGraphic" result="result7" operator="in"></feComposite>
</filter>
        </svg>`
    },500)
    }

    filterA(){
      document.documentElement.style.filter = "url(#blue)"
    }

    filterB(){
        document.documentElement.style.filter = "invert(100%)"
    }

    filterC(){
        document.documentElement.style.filter  = "url(#convo)"
    }

    blur(size){
         document.documentElement.style.filter = `blur(${size}px)`
    }
  
    filterD(){
        document.documentElement.style.filter  = "url(#anag)"
    }

    filterE(){
        document.documentElement.style.filter  = "url(#vhs)"
    }
    filterF(){
        document.documentElement.style.filter = "url(#disp)"
    }
    
    filterG(){
        document.documentElement.style.filter = "url(#k)"
    }
    close(){
        document.documentElement.style.filter = ""
    }

    create(cl){
        var a = Math.floor(Math.random()*9999+Date.now()/Math.random())
        document.body.innerHTML += `
        <svg>
          <filter id="custom${a}">
            <feColorMatrix in="SourceGraphic" values="${cl}"></feColorMatrix>
          </filter>
        </svg>
        `
        document.documentElement.style.filter = `url(#custom${a})`
    }

    createCon(cl,w,l,o){
        if(o >= 100&&o<=0&&!Number.isInteger(o)){
            return;
        }
        var a = Math.floor(Math.random()*9999+Date.now()/Math.random())
        document.body.innerHTML += `
        <svg>
          <filter id="custom${a}">
            <feConvolveMatrix in="SourceGraphic" kernelMatrix="${cl}" divisor="${w}" preserveAlpha="${!l}" order="${o}"></feColorMatrix>
          </filter>
        </svg>
        `
        document.documentElement.style.filter = `url(#custom${a})`
    }
    
}

exports.types = types;
exports.widget = Widget;
