/**
 * 
 * @author ReducedRadius
 * 
 * 该控件为2022年10月用waddle制作。
 */

function colourBlend(c1, c2, ratio) {
  ratio = Math.max(Math.min(Number(ratio), 1), 0);
  var r1 = parseInt(c1.substring(1, 3), 16);
  var g1 = parseInt(c1.substring(3, 5), 16);
  var b1 = parseInt(c1.substring(5, 7), 16);
  var r2 = parseInt(c2.substring(1, 3), 16);
  var g2 = parseInt(c2.substring(3, 5), 16);
  var b2 = parseInt(c2.substring(5, 7), 16);
  var r = Math.round(r1 * (1 - ratio) + r2 * ratio);
  var g = Math.round(g1 * (1 - ratio) + g2 * ratio);
  var b = Math.round(b1 * (1 - ratio) + b2 * ratio);
  r = ('0' + (r || 0).toString(16)).slice(-2);
  g = ('0' + (g || 0).toString(16)).slice(-2);
  b = ('0' + (b || 0).toString(16)).slice(-2);
  return '#' + r + g + b;
}

function colourRandom() {
  var num = Math.floor(Math.random() * Math.pow(2, 24));
  return '#' + ('00000' + num.toString(16)).substr(-6);
}


var document = this.document;
var window = this.window;
var navigator = this.navigator;
var history = this.history;var CryptoJS = require("crypto-js");
const utils = require('utils');

const types = {
    isInvisibleWidget: true,
    type: "COLDS_TOOL",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "工具箱",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [],
    methods: [],
    events: [],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
          console.log('Hello，欢迎使用字符串转换器');
  const color = require('color');

    }

}

types['methods'].push({
    key: 'page',
    label: '获取当前页面',
    params: [
      {
          key: 'paramName',
          label: '的',
          valueType: 'string',
          dropdown: [
    { label: 'URL', value: 'URL', },

    { label: 'url路径名', value: 'url路径名', },

    { label: '主机域名', value: '主机域名', },

    { label: '主机端口', value: '主机端口', },

    { label: '浏览器语言', value: '浏览器语言', },

    { label: '操作系统', value: '操作系统', },
  ],
      },

],
    valueType: 'string',
    blockOptions: {
    color: (colourBlend('#ffff33', '#000099', 50)),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 15,
},
})
Widget.prototype.page = function (paramName,) {
      if (paramName == 'URL') {
    return (window.location.href);} else if (paramName == 'url路径名') {
    return (window.location.pathname);} else if (paramName == '主机域名') {
    return (window.location.hostname);} else if (paramName == '主机端口') {
    return (window.location.port);} else if (paramName == '浏览器语言') {
    return (navigator.language);} else {
    return (navigator.platform);}

}
types['methods'].push({
    key: 'SCREEN',
    label: '获取当前屏幕',
    params: [
      {
          key: 'SCREEN',
          label: '的',
          valueType: 'string',
          dropdown: [
    { label: '宽度', value: '宽度', },

    { label: '高度', value: '高度', },

    { label: '可用宽', value: '可用宽', },

    { label: '可用高', value: '可用高', },
  ],
      },

],
    valueType: 'string',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.SCREEN = function (SCREEN,) {
      if (SCREEN == '宽度') {
    return (screen.width);} else if (SCREEN == '高度') {
    return (screen.height);} else if (SCREEN == '宽度') {
    return (screen.availWidth);} else if (SCREEN == '高度') {
    return (screen.availHeight);} else {
  }

}
types['methods'].push({
    key: 'CODE',
    label: '转换字符串',
    params: [
      {
          key: 'LABEL',
          label: '字符值',
          valueType: 'string',
          defaultValue: '输入什么吧',
      },
      {
          key: 'STRINGS',
          label: '为',
          valueType: 'string',
          dropdown: [
    { label: 'SHA-1', value: 'SHA-1', },

    { label: 'MD5', value: 'MD5', },

    { label: 'BASE64', value: 'BASE64', },

    { label: 'Unicode', value: 'Unicode', },
  ],
      },

],
    valueType: 'string',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.CODE = function (LABEL,STRINGS,) {
      if (STRINGS == 'SHA-1') {
    return (CryptoJS.SHA1(LABEL).toString());} else if (STRINGS == 'MD5') {
    return (CryptoJS.MD5(LABEL).toString());} else if (STRINGS == 'BASE64') {
    return (btoa(encodeURI(LABEL)));} else if (STRINGS == 'Unicode') {
    return (escape(LABEL));}

}
types['methods'].push({
    key: 'PACKED',
    label: '打包了吗？',
    params: [],
    valueType: 'boolean',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.PACKED = function () {
      return (utils.isNative());
}
types['methods'].push({
    key: 'RANDOM_COLOR',
    label: '随机颜色',
    params: [],
    valueType: 'color',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.RANDOM_COLOR = function () {
      return (colourRandom());
}
types['methods'].push({
    key: 'CURRENT_TIME_STAPE',
    label: '当前时间戳',
    params: [],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.CURRENT_TIME_STAPE = function () {
      return (new Date().getTime());
}
types['methods'].push({
    key: 'REMIX',
    label: '混合颜色',
    params: [
      {
          key: 'COLOR1',
          label: '颜色1',
          valueType: 'color',
          defaultValue: '#33cc00',
      },
      {
          key: 'COLOR2',
          label: '颜色2',
          valueType: 'color',
          defaultValue: '#ffff00',
      },
      {
          key: 'CONFIG',
          label: '混合比例（100%计）',
          valueType: 'number',
          defaultValue: 25,
      },],
    valueType: 'color',
    blockOptions: {
    color: '#33ccff',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.REMIX = function (COLOR1,COLOR2,CONFIG,) {
      return (colourBlend(COLOR1, COLOR2, CONFIG));
}
exports.types = types;
exports.widget = Widget;


