/**
 * Made by DashedRadius,2023年6月22日
 * 本控件为原创,请勿未经同意篡改并发布!
 */
var document = globalThis.document
const types = {
    isInvisibleWidget: true,
    type: "SCROLL_SENSOR_WIDGET",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "滑动感应控件",
    version: "1.0.0",
    author:"borderRadius",
    isGlobalWidget: true,
    properties: [],
    methods: [],
    events: [{
        key:"scrollup",
        label:"向上滑动",
        params:[]
    },{
        key:"scrollleft",
        label:"向左滑动",
        params:[]
    },{
        key:"scrollbelow",
        label:'向下滑动',
        params:[]
    },{
        key:"scrollright",
        label:"向右滑动",
        params:[]
    },{
        key:"micro",
        label:"滑动幅度较小或即将滑动",
        params:[{key:"x",label:"X端滑动分量",valueType:"number"},{key:"y",label:"Y端滑动分量",valueType:'number'}]
    },{
        key:"on",
        label:"滑动",
        params:[{
            key:"pressure",
            label:"压力",
            valueType:"number"
        },{key:"x",label:"X端滑动分量",valueType:"number"},{key:"y",label:"Y端滑动分量",valueType:'number'}]
    }],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        this.down = false
      document.documentElement.onpointerdown = () =>{
         this.down = true
      }
      document.documentElement.onpointerup = () =>{
        this.down = false
      }
      document.documentElement.onpointermove = (e) =>{
        if(this.down){
        this.emit("on",e.pressure,e.movementX,e.movementY)}
        if(e.movementY <-8&&this.down){
           this.emit("scrollup")
        }else if(e.movementX <-8&&this.down){
            this.emit("scrollleft")
        }else if(e.movementY >8&&this.down){
            this.emit("scrollbelow")
        }else if(e.movementX >8&&this.down){
            this.emit("scrollright")
        }else if(this.down){
            this.emit("micro",e.movementX,e.movementY)
        }
      }
    }

}

exports.types = types;
exports.widget = Widget;
