var AudioContext = globalThis.AudioContext||this.webkitAudioContext;
const types = {
    isInvisibleWidget: true,
    type: "AUDIO_FILTER_WIDGET",
    icon: "https://ocean.codemao.cn/appcraft/resource/icon/%E5%AA%92%E4%BD%93/%E5%94%B1%E7%89%87.svg",
    title: "音频特效控件",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [{
        key:"fr",
        label:"播放采样率",
        valueType:"number",
        defaultValue:44.1,
        unit:"kHz"
    },{
        key:"la",
        label:"特效效果",
        valueType:"string",
        defaultValue:"interactive",
        dropdown:[
            {label:"优先重放",value:"playback"},
            {label:"平衡",value:"balanced"},
            {label:"小延迟",value:"interactive"}
        ]
    },{
        key:"url",
        label:"播放链接",
        valueType:"string",
        defaultValue:"https://static.codemao.cn/material_1106_cn/sound/1_music/%E8%90%8C%E8%8A%BD%E7%9A%84%E6%98%A5%E5%A4%A9.mp3"
    },{
        key:"cors",
        label:"跨域携带凭证",
        valueType:"boolean",
        defaultValue:!1
    },{
        key:"loop",
        label:"循环",
        valueType:"boolean",
        defaultValue:!1
    },{
        key:"auto",
        label:"自动播放",
        valueType:"boolean",
        defaultValue:!1
    },{
        key:"fil",
        label:"均衡器模式",
        valueType:"string",
        defaultValue:"lowpass",
        dropdown:[
            {label:"低通",value:"lowpass"},
            {label:"高通",value:"highpass"},
            {label:"陷波",value:"notch"},
            {label:"尖峰",value:"peaking"},
            {label:"全通",value:'allpass'},
            {label:'低切',value:'lowshelf'},
            {label:'高切',value:'highshelf'}
        ]
    }],
    methods: [{
        key:"play",
        label:"播放",
        params:[]
    },{
        key:"pause",
        label:"暂停",
        params:[]
    },{
        key:"close",
        label:"关闭特效及音频",
        params:[]
    },{
        key:"setGain",
        label:"设置音频增益",
        params:[{
            key:"a",
            label:"",
            labelAfter:"(0为最小,1为默认,2为最大,可以取10位以上小数)",
            valueType:"number",
            defaultValue:1
        }]
    },{
        key:"fre",
        label:"设置播放频率",
        params:[{
            key:"a",
            label:"",
            labelAfter:"Hz(0-24000,注意:20Hz以下为次声波,无法听见)",
            valueType:"number",
            defaultValue:350
        }]
    },{
        key:"det",
        label:'音准差值',
        params:[{
            key:"a",
            label:"",
            labelAfter:"(值在正负153600间)",
            valueType:"number",
            defaultValue:0
        }],
        blockOptions:{
            line:"专业内容"
        }
    },{
        key:'Q',
        label:'噪音影响值',
        tooltip:"具体内容:品质因子,可见相关资料",
        params:[
        {
            key:"a",
            label:"",
            labelAfter:"(值在正负10^[-3~3](0.001-1000)间)",
            valueType:"number",
            defaultValue:1
        }
        ]
    },{
        key:"setST",
        label:"声道位置",
        params:[
            {
                key:"a",
            label:"",
            labelAfter:"(值在-1~1间,-1为左声道,0为立体声,1为右声道)",
            valueType:"number",
            defaultValue:0
            }
        ]
    },{
        key:"panner",
        label:"设置音频源偏移(所有值取值范围均为-100~100)",
        params:[
            {
                key:"a",
               label:"X方向",
               valueType:"number",
               defaultValue:0
            },{
                key:"b",
                label:"Y方向",
                valueType:"number",
                defaultValue:0
            },{
                key:"c",
               label:"Z方向",
               valueType:"number",
               defaultValue:0
            },{
                key:"d",
                label:"X位置",
                valueType:"number",
                defaultValue:0
            },{
                key:"e",
                label:"Y位置",
                valueType:"number",
                defaultValue:0
            },{
                key:"f",
                label:"Z位置",
                valueType:"number",
                defaultValue:0
            }
        ],
        blockOptions:{
           inputsInline:!1
        }
    },{
        key:"rate",
        label:"设置倍数(0.1-16)",
        params:[
            {
                key:"a",
                label:'',
                labelAfter:"x",
                valueType:"number",
                defaultValue:1
            }
        ]
    },{
        key:'delay',
        label:"播放延迟(0-179)",
        params:[
            {
                key:"a",
                label:'延迟秒数',
                labelAfter:"s",
                valueType:"number",
                defaultValue:1
            }
        ]
    }],
    events: [{
        key:"load",
        label:"加载音频出错",
        params:[]
    },{
        key:"success",
        label:"加载成功",
        params:[]
    },{
        key:"time",
        label:"进度条变化",
        params:[{
            key:"a",
            label:'当前进度',
            valueType:"number"
        },{
            key:"b",
            label:'总时长',
            valueType:"number"
        }]
    }],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        this.fil = props.fil;
      this.context = new AudioContext({sampleRate:props.fr >= 8&&props.fr <= 96?props.fr*1000:44100,latencyHint:props.la});
      this.audio = new globalThis.Audio(props.url);
      props.cors?this.audio.crossOrigin = "use-credentials":this.audio.crossOrigin = ""
      this.audio.loop = props.loop;
      this.audio.autoplay = props.auto;
      this.audio.onerror = () =>{
         this.emit('load')
      }
      this.audio.onloadedmetadata = () =>{
         this.emit("success")
      }
      this.audio.ontimeupdate = e =>{
          this.emit("time",this.audio.currentTime,this.audio.duration)
      }
      this.gain = this.context.createGain();
      this.fr = this.context.createBiquadFilter();
      this.st = this.context.createStereoPanner();
      this.pan = this.context.createPanner();
      this.b = this.context.createDelay(179)
      this.fr.type =this.fil;
     var a =  this.context.createMediaElementSource(this.audio);
     this.a = a;
     a.connect(this.gain).connect(this.fr).connect(this.st).connect(this.pan).connect(this.b).connect(this.context.destination);
    }

    play(){
        this.audio.play()
    }

    pause(){
        this.audio.pause()
    }

    setGain(a){
       if(a >=0 &&a<1){
           this.gain.gain.value = (1-a)*this.gain.gain.minValue
       }else if(a === 1){
        this.gain.gain.value = 1
       }else if(a >= 1 &&a <=2){
        this.gain.gain.value = (a-1)*this.gain.gain.maxValue
       }else{
        return
       }
    }

    fre(a){
        if(a >this.fr.frequency.maxValue||a<this.fr.frequency.minValue||Number(a) === NaN){this.widgetError("取值错误,目前仅支持正负"+Math.abs(this.fr.frequency.minValue)+"的值");return;}
        this.fr.frequency.value = a
    }

    det(a){
        if(a >this.fr.detune.maxValue||a<this.fr.detune.minValue||Number(a) === NaN||!Number.isInteger(a)){this.widgetError("取值错误,目前仅支持正负"+Math.abs(this.fr.detune.minValue)+"的整数");return;}
        this.fr.detune.value = a
    }

    close(){
        this.a.disconnect()
    }

    Q(a){
        if(a >this.fr.Q.maxValue||a<this.fr.Q.minValue||Number(a) === NaN){this.widgetError("取值错误,目前仅支持0.001-1000");return;}
        this.fr.Q.value = a
    }

    setST(a){
        if(Math.abs(a) <=1){
       this.st.pan.value = a;
        }
    }
   

    pann(a,b,c,d,e,f){
        Array.from(arguments).forEach(v =>{
            if(v > 100||v< -100||typeof v != "number"){
                this.widgetError("偏移部分值无效,请检查")
            }
        })
        this.pan.orientationX = a*3.4028234663852886e36;
        this.pan.orientationY = b*3.4028234663852886e36;
        this.pan.orientationZ = c*3.4028234663852886e36;
        this.pan.positionX = d*3.4028234663852886e36;
        this.pan.positionY = e*3.4028234663852886e36;
        this.pan.positionZ = f*3.4028234663852886e36;
    }

    rate(a){
        this.audio.playbackRate = a;
    }

    delay(a){
        this.b.delayTime.value = a
    }
}


types["properties"].forEach(e =>{
    e.blockOptions = {
        generateBlock:!1
    }
})

exports.types = types;
exports.widget = Widget;
