const types = {
    isInvisibleWidget: false,
    type: "FONT_SMALLER_WIDGET",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "极小字体",
    version: "1.0.0",
    auther:"DashedRadius",
    isGlobalWidget: false,
    properties: [{
        key: '__width',
        label: '宽度',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__height',
        label: '高度',
        valueType: 'number',
        defaultValue: 150,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },{
        key:"content",
        label:"内容",
        valueType:"string",
        editorType:"TextArea",
        defaultValue:"文本"
    },{
        key:"fontSize",
        label:"字体大小",
        valueType:"number",
        defaultValue:5
    },{
        key:"color",
        label:"字体颜色",
        valueType:"color",
        defaultValue:"#000000"
    },{
      key:"s",
      label:"水平对齐",
      valueType:"string",
      dropdown:[
        {label:"左侧",value:"left"},
        {label:"中央",value:"center"},
        {label:"右侧",value:"right"}
      ],
      defaultValue:"center"
    },{
      key:"bg",
      label:"背景色",
      valueType:"color",
      defaultValue:"#ffffff"
    }],
    methods: [],
    events: [],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
       this.widgetLog("本控件按照 https://shequ.codemao.cn/community/552305 制作而成")
       this.content = props.content;
       this.__width = props.__width;
       this.__height = props.__height;
       this.bg = props.bg;
       this.s = props.s;
       if(props.fontSize <12&&props.fontSize  >0){
        this.fontSize = 12
         this.scale = (props.fontSize /12).toFixed(3)
       }else{
          this.fontSize = props.fontSize;
          this.scale = 1
       }
    }

    render(){
        return (<span style={{
            width:"100%",
            height:"100%",
            display:"block",
            fontSize:this.fontSize+'px',
            transform:`scale(${this.scale})`,
            textAlign:this.s,
            backgroundColor:this.bg
        }}>{this.content}</span>)
    }

}

exports.types = types;
exports.widget = Widget;
