//Made by ReducedRadius, 2023年8月2日
var document = globalThis.document;
const id = Math.round(Math.random()*99999)+"dr"

const types = {
    isInvisibleWidget: false,
    type: "DR_CHART_WIDGET",
    icon: "icon-widget-local-storage",
    title: "图表控件",
    auther:"ReducedRadius",
    version: "1.0.0",
    isGlobalWidget: false,
    properties: [
      {
        key: '__width',
        label: '宽度',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__height',
        label: '高度',
        valueType: 'number',
        defaultValue: 150,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },
      {
        key:"tp",
        label:'类型',
        valueType:"string",
        defaultValue:"bar",
        dropdown:[
            {label:'条形统计图',value:"bar"},
            {label:'折线',value:"line"},
            {label:'泡泡图',value:"bubble"},
            {label:'圆环图',value:"doughnut"},
            {label:'饼图',value:"pie"},
            {label:'玫瑰图',value:"polarArea"},
            {label:"雷达图",value:"radar"},
            {label:"散点图",value:"scatter"}
        ]
      },{
        key:'label',
        label:'各数据标识',
        valueType:"string",
        editorType:"TextArea",
        defaultValue:"正,反,中立,弃权"
      },{
        key:"data",
        label:'各数据值',
        valueType:"string",
        editorType:"TextArea",
        defaultValue:"52,46,1,1"
      },{
        key:'pic',
        label:'图表值名',
        valueType:"string",
        defaultValue:"投票百分比"
      },{
        key:"title",
        label:'标题',
        valueType:"string",
        defaultValue:"XX投票结果"
      },{
        key:"bgColor",
        label:'画布背景颜色',
        valueType:"color",
        defaultValue:"#eeeeee"
      },{
        key:'border',
        label:"数据背景色组",
        valueType:"string",
        defaultValue:"#0312ee,#b4d2f0,#00ff00,#000000"
      },{
        key:"text",
        label:'标题文本颜色',
        valueType:"color",
        defaultValue:"#000000"
      },{
        key:"minmax",
        label:"Y坐标最小//最大值",
        valueType:"string",
        defaultValue:"0,60"
      },{
        key:'log',
        label:'Y轴对数增长',
        valueType:"boolean",
        defaultValue:false
      },{
        key:'Y',
        label:"Y轴说明",
        valueType:"string",
        defaultValue:"票数"
      },{
        key:"X",
        label:"X轴说明",
        valueType:"string",
        defaultValue:"态度"
      },{
        key:"xminmax",
        label:'X轴最小最大值(如果有)',
        valueType:"string",
        defaultValue:"0,60"
      },{
        key:"br",
        label:'项目圆角值',
        valueType:"number",
        defaultValue:3
      },{
        key:"borderColor",
        label:'项目边框色',
        valueType:"color",
        defaultValue:"#000000"
      }
    ],
    methods: [{
        key:"draw",
        label:'刷新并渲染图表',
        params:[]
    },{
        key:"addData",
        label:'添加数据',
        params:[
            {
                key:'label',
                label:'标识文本或数值',
                valueType:["string","number"],
                defaultValue:"名称"
            },{
                key:"value",
                label:'值',
                valueType:"number",
                defaultValue:2
            },{
                key:"color",
                label:'颜色',
                valueType:"color",
                defaultValue:"#000000"
            }
        ]
    },{
      key:'pop',
      label:'删除最后一项',
      params:[]
    },{
      key:"del",
      label:'删除第',
      params:[
        {
          key:'index',
          label:'',
          labelAfter:"项",
          valueType:"number",
          defaultValue:1
        }
      ]
    },{
      key:"captureImage",
      label:"截取图片",
      valueType:"string",
      params:[
        {
          key:"type",
          label:'文件后缀',
          valueType:"string",
          defaultValue:"image/png",
          dropdown:[
            {label:'PNG',value:"image/png"},
            {label:"JPG",value:"image/jpeg"},
            {label:"WEBP",value:"image/webp"}
          ]
        },{
          key:"quality",
          label:"图片质量(0-100)",
          valueType:"number",
          defaultValue:92
        }
      ]
    },{
      key:"length",
      label:'获取列表长度',
      params:[],
      valueType:"number"
    },{
      key:"getItem",
      label:'获取列表第',
      valueType:"number",
      params:[
        {
          key:'index',
          label:'',
          labelAfter:"项的值",
          valueType:"number",
          defaultValue:1
        }
      ]
    }],
    events: [],
  };
  
  class Widget extends VisibleWidget {
    a = false
    chart
    constructor(props) {
      super(props);
      this.__width = props.__width;
      this.__height = props.__height;
      this.bgColor = props.bgColor;
      this.log = props.log;
      this.borderColor  = props.borderColor
    var s = document.createElement("script");
    s.src = "https://unpkg.com/chart.js@4.3.2/dist/chart.umd.js";
    document.body.appendChild(s);
    this.tp = props.tp;
    this.data = props.data;
    this.label = props.label;
    this.br = props.br;
    this.pic = props.pic;
    this.title = props.title;
    this.border = props.border;
    this.text = props.text;
    this.img = props.img;
    this.xminmax = props.xminmax;
    this.Y = props.Y;this.X = props.X;
    this.minmax = props.minmax;
  var a =  setInterval(_e =>{
        if(document.getElementById(id)&&globalThis.Chart){
            if(this.img){
                var list = this.border.split(",")
           var pat = document.querySelector("canvas").getContext("2d").createLinearGradient(0,0,500,500);
           list.forEach((value,index) =>{
             pat.addColorStop(index/list.length,value)
           })
           this.pattern = list;
    }
                clearInterval(a)
                this.a = true
        }
    })
    }
    render() {
      return(
      <canvas id={id} style={{
        height:this.__height,
        width:this.__width,
        backgroundColor:this.bgColor
      }}></canvas>
    );
    }
    
    draw(){
        var a = () =>{
            if(this.log){
                return {
                    type:"logarithmic",
                    title:{
                        display:true,
                        text:this.Y
                    }
                }
            }else if(this.minmax.split(",").length > 1){
                return {
                    min:Number(this.minmax.split(",")[0]),
                    max:Number(this.minmax.split(",")[1]),
                    title:{
                        display:true,
                        text:this.Y
                    }
                }
            }
        }
        if(this.a||(globalThis.Chart&&document.getElementById(id))){
           this.chart = new Chart(document.getElementById(id),{
                type:this.tp,
                data:{
                    labels:this.label.split(","),
                    datasets:[{
                        label:this.pic,
                        data:this.data.split(","),
                        borderWidth:1,
                        borderRadius:this.br,
                        backgroundColor:this.border.split(","),
                        borderColor:this.borderColor
                    }]
                },
                options:{
                    scales:{
                        y:a(),
                        x:{
                            title:{
                                text:this.X,
                                display:true
                            },
                            min:Number(this.xminmax.split(",")[0]),
                            max:Number(this.xminmax.split(",")[1])
                        }
                    },
                    plugins:{
                        title:{
                            display:true,
                            text:this.title,
                            color:this.text
                        }
                    }
                }
            })
        }else{
            this.widgetError("图表控件尚未载入完成,请在开始后至少0.5秒后再尝试")
        }
    }

    addData(label = "无名",value = 15,color = ""){
      if(!this.chart){this.widgetError("需要先渲染图表!");return}
        const data = this.chart.data;
        console.log(data)
        data.datasets[0].data.push(value);
        data.labels.push(label);
      if(color !== ""&&typeof color === "string"){
        data.datasets[0].backgroundColor.push(color);
      }
        this.chart.update()
    }

    pop(){
      if(!this.chart){this.widgetError("需要先渲染图表!");return}
      const data = this.chart.data;
      data.datasets[0].data.pop()
      data.labels.pop();
      this.chart.update()
    }

    del(index){
      if(!this.chart){this.widgetError("需要先渲染图表!");return};
      const data = this.chart.data;
       data.datasets[0].data.splice(index-1,1);
       data.labels.splice(index-1,1);
      this.chart.update()
    }

    captureImage(type,quality){
    if(this.a){return document.getElementById(id).toDataURL(type,quality >100||quality<0||Number(quality) === NaN?1:quality/100)}
    }

    length(){
      if(!this.chart){this.widgetError("需要先渲染图表!");return}
      return this.chart.data.datasets[0].data.length
    }

    getItem(index){
      if(!this.chart){this.widgetError("需要先渲染图表!");return};
     return this.chart.data.datasets[0].data[index-1]
    }

  }

 
  types["methods"].forEach(e =>{
      e.blockOptions = {
        callMethodLabel:false,
        space:30,
        color:"#53A2C9"
      }
  })
  
  exports.types = types;
  exports.widget = Widget;
  