// Created By ReducedRadius.
const types = {
  isInvisibleWidget: false,
  type: "REACT_HTML_DOM_SCRIPT",
  icon: "https://static.codemao.cn/nemo/avatar/avator_4.png",
  title: "React渲染积木",
  version: "1.0.0",
  isGlobalWidget: false,
  properties: [
    {
      key: '__width',
      label: '控件宽度',
      valueType: 'number',
      defaultValue: 200,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__height',
      label: '控件高度',
      valueType: 'number',
      defaultValue: 150,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__size',
      label: '大小',
      valueType: 'number',
      defaultValue: 0,
      readonly: false,
      blockOptions: {
        setter: {
          keys: ['__height', '__width'],
        },
        getter: {
          keys: ['__height', '__width'],
        },
      },
    },
  ],
  methods: [],
  events: [],
};

class Widget extends VisibleWidget {
  constructor(props) {
    super(props);
    this.__width = props.__width;
    this.__height = props.__height;
    this.content=props.content;
  this.TEX=props.TEX;
  this.Colors=props.Colors;

  }
  render() {
    return(
      React.createElement("div", {  style: {  color: (this.Colors),
      },
    }, [React.createElement("div", {dangerouslySetInnerHTML: {__html: (this.content)}}, null),
      React.createElement("div", {dangerouslySetInnerHTML: {__html: (this.TEX)}}, null),])
  );

  }
}

types['properties'].push({
    key: 'TEX',
    label: '引入文本',
    valueType: 'string',
    defaultValue: "",

})

types['properties'].push({
    key: 'Colors',
    label: '颜色',
    valueType: 'color',
    defaultValue: '#ff0000',

})

types['methods'].push({
    key: 'BLOCKA',
    label: '新建超链接',
    params: [
      {
          key: 'LINK',
          label: '跳转链接',
          valueType: 'string',
          defaultValue: 'https://shequ.codemao.cn/user/1666851341',
      },
      {
          key: 'TEXTURE',
          label: '文本',
          valueType: 'string',
          defaultValue: '作者首页链接',
      },
      {
          key: 'STYLE',
          label: '样式',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: "",
      },
      {
          key: 'PROPP',
          label: '其他附加属性',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: "",
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 16,
},
})
Widget.prototype.BLOCKA = function (LINK,TEXTURE,STYLE,PROPP,) {
      this.setProps({ 'content': ([this.content,['<a href="',LINK,'" style="'].join(''),String(STYLE) + '"',String(PROPP) + '>',TEXTURE,'</a>'].join('')) });

}
types['methods'].push({
    key: 'BLOCKD',
    label: '新建粗体文本',
    params: [
      {
          key: 'TEXTBOLD',
          label: '文本',
          valueType: 'string',
          defaultValue: 'Welcome',
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 20,
},
})
Widget.prototype.BLOCKD = function (TEXTBOLD,) {
      this.setProps({ 'content': ([this.content,'<b>',TEXTBOLD,'</b>'].join('')) });

}
types['methods'].push({
    key: 'BLOCKF',
    label: '新建斜体文本',
    params: [
      {
          key: 'TEXTI',
          label: '文本',
          valueType: 'string',
          defaultValue: 'Welcome Here',
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 20,
},
})
Widget.prototype.BLOCKF = function (TEXTI,) {
      this.setProps({ 'content': ([this.content,'<i>',TEXTI,'</i>'].join('')) });

}
types['methods'].push({
    key: 'BLOCKH',
    label: '新建删除线文本',
    params: [
      {
          key: 'TEXTD',
          label: '文本',
          valueType: 'string',
          defaultValue: '我就是个',
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 20,
},
})
Widget.prototype.BLOCKH = function (TEXTD,) {
      this.setProps({ 'content': ([this.content,'<del>',TEXTD,'</del>'].join('')) });

}
types['methods'].push({
    key: 'BLOCKMFJFIWUFHFU',
    label: '新建下划线文本',
    params: [
      {
          key: 'TEXTM',
          label: '文本',
          valueType: 'string',
          defaultValue: '哎呀，你干嘛',
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 20,
},
})
Widget.prototype.BLOCKMFJFIWUFHFU = function (TEXTM,) {
      this.setProps({ 'content': ([this.content,'<u',TEXTM,'</u>'].join('')) });

}
types['methods'].push({
    key: 'BLOCKMAR',
    label: '新建记号文本',
    params: [
      {
          key: 'TEXTM',
          label: '文本',
          valueType: 'string',
          defaultValue: '我就是个',
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 20,
},
})
Widget.prototype.BLOCKMAR = function (TEXTM,) {
      this.setProps({ 'content': ([this.content,'<mark>',TEXTM,'</mark>'].join('')) });

}
types['methods'].push({
    key: 'BLOCKM',
    label: '新建可定义字体文本',
    params: [
      {
          key: 'TEXTF',
          label: '文本',
          valueType: 'string',
          defaultValue: '字体可以自定义啦',
      },
      {
          key: 'TEXTFO',
          label: '字体（您的电脑必须安装）',
          valueType: 'string',
          defaultValue: '楷体',
      },
      {
          key: 'TEXTSIZE',
          label: '字体大小',
          valueType: 'number',
          defaultValue: 8,
      },
      {
          key: 'TEXTCOL',
          label: '字体颜色',
          valueType: 'color',
          defaultValue: '#00cccc',
      },
      {
          key: 'STYLES',
          label: '样式',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: "",
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.BLOCKM = function (TEXTF,TEXTFO,TEXTSIZE,TEXTCOL,STYLES,) {
      this.setProps({ 'content': ([this.content,'<font face="' + String(String(TEXTFO) + String('" size="' + String(String(TEXTSIZE) + String('" color="' + String(String(TEXTCOL) + String('" style="' + String(String(STYLES) + '">'))))))),TEXTF,'</font>'].join('')) });

}
types['methods'].push({
    key: 'BLOCKN',
    label: '新建标题文本',
    params: [
      {
          key: 'OBJ',
          label: '内容',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'LEV',
          label: '级别',
          valueType: 'string',
          dropdown: [
    { label: '1', value: '1', },

    { label: '2', value: '2', },

    { label: '3', value: '3', },

    { label: '4', value: '4', },

    { label: '5', value: '5', },

    { label: '6', value: '6', },
  ],
      },


      {
          key: 'STR',
          label: '样式',
          valueType: 'string',
          defaultValue: "",
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.BLOCKN = function (OBJ,LEV,STR,) {
      this.setProps({ 'content': ([this.content,'<h',LEV,' style="',STR,'">',String(OBJ) + String('</h' + String(LEV)),'>'].join('')) });

}
types['methods'].push({
    key: 'METER',
    label: '新建进度条(测试状态)',
    params: [
      {
          key: 'STRSS',
          label: '样式',
          valueType: 'string',
          defaultValue: 'color: pink;',
      },
      {
          key: 'VAL',
          label: '当前值',
          valueType: 'number',
          defaultValue: 50,
      },
      {
          key: 'MIN',
          label: '最小值',
          valueType: 'number',
          defaultValue: 1,
      },
      {
          key: 'MAX',
          label: '最大值',
          valueType: 'number',
          defaultValue: 100,
      },
      {
          key: 'TXT',
          label: '嵌入文本',
          valueType: 'string',
          defaultValue: "",
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: false,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.METER = function (STRSS,VAL,MIN,MAX,TXT,) {
      this.setProps({ 'content': ([this.content,'<meter ','value="' + String(VAL),' min="' + String(MIN),String(' max="' + String(MAX)) + String('style="' + String(STRSS)),'">',TXT,'</meter>'].join('')) });

}
types['methods'].push({
    key: 'VID',
    label: '新建视频',
    params: [
      {
          key: 'SRC',
          label: '源文件',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'STYY',
          label: '样式',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'OTHERS',
          label: '其他属性',
          valueType: 'string',
          defaultValue: "",
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.VID = function (SRC,STYY,OTHERS,) {
      this.setProps({ 'content': ([this.content,'<video src="',SRC,'" style="',STYY,'"',OTHERS,'>','</video>'].join('')) });

}
types['methods'].push({
    key: 'AUD',
    label: '新建音频',
    params: [
      {
          key: 'SRC',
          label: '源媒体',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'STYYA',
          label: '样式',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'OTHERS',
          label: '其他属性',
          valueType: 'string',
          defaultValue: "",
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.AUD = function (SRC,STYYA,OTHERS,) {
      this.setProps({ 'content': ([this.content,'<audio src="',SRC,'" style="',STYYA,'"',OTHERS,'>','</audio>'].join('')) });

}
types['methods'].push({
    key: 'IMG',
    label: '新建图像',
    params: [
      {
          key: 'SRC',
          label: '源图片',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'ALT',
          label: '代替文本（必填）',
          valueType: 'string',
          defaultValue: '当没有图片时，这个会生效',
      },
      {
          key: 'ST',
          label: '样式',
          valueType: 'string',
          defaultValue: "",
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.IMG = function (SRC,ALT,ST,) {
      this.setProps({ 'content': ([this.content,'<img src="',SRC,'"alt="',ALT,'" style="',ST,'">' + '</img>'].join('')) });

}
types['methods'].push({
    key: 'SCRIPT',
    label: '新建脚本',
    params: [
      {
          key: 'SCR',
          label: '脚本内容(暂时只支持JavaScript)',
          valueType: 'multilineString',
      checkType: 'string',
          defaultValue: 'alert("1");',
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: false,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.SCRIPT = function (SCR,) {
      this.setProps({ 'content': ([this.content,'<script type="text/javascript" >',SCR,'</script>'].join('')) });

}
types['methods'].push({
    key: 'BR',
    label: '新建换行',
    params: [],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.BR = function () {
      this.setProps({ 'content': (String(this.content) + '<br>') });

}
types['methods'].push({
    key: 'STYLESHEET',
    label: '新建样式',
    params: [
      {
          key: 'CSSCODE',
          label: '样式内容',
          valueType: 'multilineString',
      checkType: 'string',
          defaultValue: '.p {background-color: red;}',
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 20,
},
})
Widget.prototype.STYLESHEET = function (CSSCODE,) {
      this.setProps({ 'content': ([this.content,'<style>',CSSCODE,'</style>'].join('')) });

}
types['methods'].push({
    key: 'IFRAME',
    label: '创建框架',
    params: [
      {
          key: 'SRC',
          label: '源网页',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'OBJ',
          label: '样式',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'PERMIS',
          label: '最大程度上限制关闭',
          valueType: 'boolean',
          defaultValue: true,
      },
      {
          key: 'HEI',
          label: '高度',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: '80%',
      },
      {
          key: 'WID',
          label: '宽度',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: '80%',
      },],

    blockOptions: {
    color: '#ffbb55',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 28,
},
})
Widget.prototype.IFRAME = function (SRC,OBJ,PERMIS,HEI,WID,) {
      if (PERMIS) {
    this.setProps({ 'content': ([this.content,'<iframe src="',SRC,String('" height="' + String(HEI)) + String('sandbox="' + String('allow-forms allow-same-origin allow-scripts allow-top-navigation allow-modals allow-popups' + String(String('width="' + String(WID)) + ' style="'))),OBJ,'">','</iframe>'].join('')) });
  } else {
    this.setProps({ 'content': ([this.content,'<iframe src="',SRC,String('" height="' + String(HEI)) + String('sandbox="' + String('"' + String(String('width="' + String(WID)) + ' style="'))),OBJ,'">','</iframe>'].join('')) });
  }

}
types['methods'].push({
    key: 'RETURN',
    label: '返回元素值',
    params: [],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.RETURN = function () {
      return (String(this.content) + String(this.TEX));
}
types['methods'].push({
    key: 'ELE',
    label: '替换元素内容',
    params: [
      {
          key: 'elename',
          label: '元素名或完整属性样式名',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'REPLACE',
          label: '替换为',
          valueType: 'string',
          defaultValue: "",
      },],

    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.ELE = function (elename,REPLACE,) {
      this.setProps({ 'content': (this.content.replaceAll(elename,REPLACE)) });

}
types['methods'].push({
    key: 'BLOCKI',
    label: '清空元素内容',
    params: [],

    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.BLOCKI = function () {
      this.setProps({ 'content': '' });

}
types['methods'].push({
    key: 'BLOCKL',
    label: '如果满足',
    params: [
      {
          key: 'PARO',
          label: '条件',
          valueType: 'boolean',
          defaultValue: false,
      },
      {
          key: 'PART',
          label: '输出文本',
          valueType: 'string',
          defaultValue: 'true',
      },
      {
          key: 'PARH',
          label: '否则输出文本',
          valueType: 'string',
          defaultValue: 'false',
      },],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.BLOCKL = function (PARO,PART,PARH,) {
      return (PARO ? PART : PARH);
}
types['methods'].push({
    key: 'PROPSIN',
    label: '自定义属性',
    params: [
      {
          key: 'NAME',
          label: '属性名',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'VAL',
          label: '属性值',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: "",
      },],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.PROPSIN = function (NAME,VAL,) {
      return (String(NAME) + String('="' + String(String(VAL) + '"')));
}
types['methods'].push({
    key: 'TABS',
    label: '自定义HTML标签',
    params: [
      {
          key: 'TAB',
          label: '标签名',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'PPROP',
          label: '属性(包括属性名属性值）',
          valueType: 'string',
          defaultValue: "",
      },],

    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 28,
},
})
Widget.prototype.TABS = function (TAB,PPROP,) {
      this.setProps({ 'content': (String(this.content) + String(['<',TAB,' ' + String(PROP),'></' + String(String(TAB) + '>')].join(''))) });

}
types['methods'].push({
    key: 'STYLEIN',
    label: '自定义样式',
    params: [
      {
          key: 'NAMSE',
          label: '样式名',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'VALU',
          label: '样式值',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: "",
      },],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: '#ff0000',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 20,
},
})
Widget.prototype.STYLEIN = function (NAMSE,VALU,) {
      return (String(NAMSE) + String(':' + String(String(VALU) + ';')));
}
types['methods'].push({
    key: 'BLOCKC',
    label: '定义样式',
    params: [
      {
          key: 'DROPDOWN',
          label: '的内容',
          valueType: 'string',
          dropdown: [
    { label: '高度', value: '高度', },

    { label: '宽度', value: '宽度', },

    { label: '文本间距', value: '文本间距', },

    { label: '字体大小', value: '字体大小', },
  ],
      },


      {
          key: 'VALUE',
          label: '为',
          valueType: 'number',
          defaultValue: "",
      },],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: '#ff0000',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.BLOCKC = function (DROPDOWN,VALUE,) {
      if (DROPDOWN == '高度') {
    return (['height:',VALUE,'px;'].join(''));} else if (DROPDOWN == '宽度') {
    return (['width:',VALUE,'px;'].join(''));} else if (DROPDOWN == '字体大小') {
    return (['font-size:',VALUE,'px;'].join(''));} else {
    return (['letter-spacing:',VALUE,'px;'].join(''));}

}
types['methods'].push({
    key: 'BLOCKE',
    label: '定义字体阴影模糊效果',
    params: [
      {
          key: 'HE',
          label: '高度',
          valueType: 'number',
          defaultValue: 8,
      },
      {
          key: 'WI',
          label: '宽度',
          valueType: 'number',
          defaultValue: 8,
      },
      {
          key: 'BL',
          label: '模糊值',
          valueType: 'number',
          defaultValue: 3,
      },
      {
          key: 'COL',
          label: '颜色',
          valueType: 'color',
          defaultValue: '#00cccc',
      },],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: '#ff0000',
    icon: '无',
    generateBlock: true,
    inputsInline: false,
    space: 16,
},
})
Widget.prototype.BLOCKE = function (HE,WI,BL,COL,) {
      return ('text-shadow:' + String(String(String(HE) + 'px ') + String(String(String(WI) + 'px ') + String(String(String(BL) + 'px ') + String(String(COL) + ';')))));
}
types['methods'].push({
    key: 'BLOCKK',
    label: '定义字体粗细为',
    params: [
      {
          key: 'PAR',
          label: '多少',
          valueType: 'string',
          dropdown: [
    { label: '100', value: '100', },

    { label: '200', value: '200', },

    { label: '300', value: '300', },

    { label: '400', value: '400', },

    { label: '500', value: '500', },

    { label: '600', value: '600', },

    { label: '700', value: '700', },

    { label: '800', value: '800', },

    { label: '900', value: '900', },
  ],
      },

],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: '#ff0000',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.BLOCKK = function (PAR,) {
      return (['font-weight:',PAR,';'].join(''));
}
types['methods'].push({
    key: 'CSSADV',
    label: '高级定义CSS',
    params: [
      {
          key: 'IN',
          label: '定义',
          valueType: 'string',
          dropdown: [
    { label: 'border-style', value: 'border-style', },

    { label: 'border-width', value: 'border-width', },

    { label: 'border-color', value: 'border-color', },

    { label: 'margin', value: 'margin', },

    { label: 'color', value: 'color', },

    { label: 'background-image', value: 'background-image', },

    { label: 'text-align', value: 'text-align', },

    { label: 'text-decoration', value: 'text-decoration', },

    { label: 'font-family', value: 'font-family', },

    { label: 'border-spacing', value: 'border-spacing', },

    { label: 'text-justify', value: 'text-justify', },

    { label: 'word-break', value: 'word-break', },

    { label: 'display', value: 'display', },

    { label: 'word-wrap', value: 'word-wrap', },
  ],
      },


      {
          key: 'NUM',
          label: '数值',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: "",
      },],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: '#ff0000',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.CSSADV = function (IN,NUM,) {
      return ([IN,':',NUM,';'].join(''));
}
exports.types = types;
exports.widget = Widget;
