const types = {
    isInvisibleWidget: true,
    type: "UNICODE_ENDECODE_WIDGET",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "Unicode加解密控件",
    auther:"DashedRadius",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [],
    methods: [{key:'a',label:"加密",valueType:"string",params:[{key:"t",label:"文本",valueType:"string",defaultValue:"",}]},
    {key:'b',label:"解密",valueType:"string",params:[{key:"t",label:"文本",valueType:"string",defaultValue:""}]}],
    events: [],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
    }

    a(t){
        var myvalue = ""
        for (let index = 0; index < t.length; index++) {
            const element = t[index];
            switch (element.charCodeAt().toString(16).length){
                case 1:
                myvalue+= "\\u"+"000"+element.charCodeAt().toString(16)
                break;
                case 2:
                myvalue+= "\\u"+"00"+element.charCodeAt().toString(16)
                break;
                case 3:
                myvalue+= "\\u"+"0"+element.charCodeAt().toString(16)
                break;
                default:
                myvalue+= "\\u"+element.charCodeAt().toString(16)
                break;
            }
        }
        return myvalue
    }
    b(t){
        const reg = /[g-z]|[G-Z]/
        const data = String(t);
        var origin = ""
        var a = data.split("\\u")
        a.shift()
        console.log(a)
        a.forEach(e =>{
            try{
                console.log(parseInt(e,16))
                if(parseInt(e,16) === NaN){throw new Error("不能进行\\u"+e+"数值的转换!")}
                else if(reg.exec(e)){
                    throw new Error("不能进行\\u"+e+"数值的转换!")
                }
            const Str = String.fromCharCode(parseInt(e,16));
            origin += Str;
            }catch(e){
               this.widgetError(e.message)
            }
        })
        while(origin.length === a.length){
            return origin;
        }
    }

}

exports.types = types;
exports.widget = Widget;
