
const antd = require("antd-mobile");
const types = {
    isInvisibleWidget: false,
    type: "ANTD_NOTICE_WIDGET",
    icon: "icon-dialog",
    title: "antd通告栏控件",
    version: "1.0.0",
    isGlobalWidget: false,
    properties: [
      {
        key: '__width',
        label: '宽度',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__height',
        label: '高度',
        valueType: 'number',
        defaultValue: 150,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },{
        key:"text",
        label:"文本",
        valueType:"string",
        defaultValue:"hi!"
      },{
        key:"closable",
        label:"可关闭",
        valueType:"boolean",
        defaultValue:false
      },{
        key:"wrap",
        label:"多行展示",
        valueType:"boolean",
        defaultValue:false
      },{
        key:"delay",
        label:"滚动延迟",
        valueType:"number",
        defaultValue:0.1,
        unit:"秒"
      },{
        key:"speed",
        label:"滚动速度",
        valueType:"number",
        defaultValue:6,
        unit:"像素/秒"
      },{
        key:'tp',
        label:'类型',
        valueType:"string",
        defaultValue:"default",
        dropdown:[
          {label:"灰色默认",value:"default"},
          {label:'黄色警告',value:"alert"},
          {label:"红色错误",value:"error"},
          {label:'浅蓝信息',value:"info"}
        ]
      },{
        key:"sizes",
        label:"大小",
        valueType:"number",
        defaultValue:15
      },{
        key:"colors",
        label:"文本色",
        valueType:"color",
        defaultValue:"#000000"
      },{
        key:"border",
        label:"边框色",
        valueType:"color",
        defaultValue:"#999999"
      }
    ],
    methods: [],
    events: [{
      key:"onClose",
      label:'被关闭',
      params:[]
    }],
  };
  
  class Widget extends VisibleWidget {
    constructor(props) {
      super(props);
      Object.assign(this,props)
    }
    render = () =>{
      return(<antd.NoticeBar content={this.text} closeable={this.closable} wrap={this.wrap} delay={this.delay*1000} speed={this.speed} color={this.tp} style={{
        fontSize:this.sizes+"px",
        color:this.colors,
        borderColor:this.border,
        height:this.__height__+"px"
      }} onClick={e =>this.emit("onClick")} onClose={e =>this.emit("onClose")}></antd.NoticeBar>)
    }
    
    

    


  }
  
  exports.types = types;
  exports.widget = Widget;
  