//控件在2024.8.4修复bug
var object;

function colourBlend(c1, c2, ratio) {
  ratio = Math.max(Math.min(Number(ratio), 1), 0);
  var r1 = parseInt(c1.substring(1, 3), 16);
  var g1 = parseInt(c1.substring(3, 5), 16);
  var b1 = parseInt(c1.substring(5, 7), 16);
  var r2 = parseInt(c2.substring(1, 3), 16);
  var g2 = parseInt(c2.substring(3, 5), 16);
  var b2 = parseInt(c2.substring(5, 7), 16);
  var r = Math.round(r1 * (1 - ratio) + r2 * ratio);
  var g = Math.round(g1 * (1 - ratio) + g2 * ratio);
  var b = Math.round(b1 * (1 - ratio) + b2 * ratio);
  r = ('0' + (r || 0).toString(16)).slice(-2);
  g = ('0' + (g || 0).toString(16)).slice(-2);
  b = ('0' + (b || 0).toString(16)).slice(-2);
  return '#' + r + g + b;
}

function colourRandom() {
  var num = Math.floor(Math.random() * Math.pow(2, 24));
  return '#' + ('00000' + num.toString(16)).substr(-6);
}

function mathMean(myList) {
  return myList.reduce(function(x, y) {return x + y;}) / myList.length;
}

function mathMedian(myList) {
  var localList = myList.filter(function (x) {return typeof x === 'number';});
  if (!localList.length) return null;
  localList.sort(function(a, b) {return b - a;});
  if (localList.length % 2 === 0) {
    return (localList[localList.length / 2 - 1] + localList[localList.length / 2]) / 2;
  } else {
    return localList[(localList.length - 1) / 2];
  }
}

function mathModes(values) {
  var modes = [];
  var counts = [];
  var maxCount = 0;
  for (var i = 0; i < values.length; i++) {
    var value = values[i];
    var found = false;
    var thisCount;
    for (var j = 0; j < counts.length; j++) {
      if (counts[j][0] === value) {
        thisCount = ++counts[j][1];
        found = true;
        break;
      }
    }
    if (!found) {
      counts.push([value, 1]);
      thisCount = 1;
    }
    maxCount = Math.max(thisCount, maxCount);
  }
  for (var j = 0; j < counts.length; j++) {
    if (counts[j][1] === maxCount) {
        modes.push(counts[j][0]);
    }
  }
  return modes;
}

function mathStandardDeviation(numbers) {
  var n = numbers.length;
  if (!n) return null;
  var mean = numbers.reduce(function(x, y) {return x + y;}) / n;
  var variance = 0;
  for (var j = 0; j < n; j++) {
    variance += Math.pow(numbers[j] - mean, 2);
  }
  variance = variance / n;
  return Math.sqrt(variance);
}


var document = this.document;
var window = this.window;
var navigator = this.navigator;
var history = this.history;var CryptoJS = require("crypto-js");
const utils = require('utils');
const qrcode = require('qrcode');

const types = {
    isInvisibleWidget: true,
    type: "COLDS_TOOL",
    icon: "https://creation.codemao.cn/716/appcraft/IMAGE_xDcLn6gyo_1667117123797.png",
    title: "工具箱",
    version: "1.1.0",
    isGlobalWidget: true,
    properties: [],
    methods: [],
    events: [],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
          console.log('Hello，欢迎使用工具箱');
  this.widgetLog('欢迎使用coldsqurriel的工具箱~(*^▽^*)');
  const color = require('color');

    }

}

types['methods'].push({
    key: 'page',
    label: '获取当前页面',
    params: [
      {
          key: 'paramName',
          label: '的',
          valueType: 'string',
          dropdown: [
    { label: 'URL', value: 'URL', },

    { label: 'url路径名', value: 'url路径名', },

    { label: '主机域名', value: '主机域名', },

    { label: '主机端口', value: '主机端口', },

    { label: '浏览器语言', value: '浏览器语言', },

    { label: '操作系统', value: '操作系统', },
  ],
      },

],
    valueType: 'string',
    blockOptions: {
    color: (colourBlend('#ffff33', '#000099', 50)),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 15,
},
})
Widget.prototype.page = function (paramName,) {
      if (paramName == 'URL（链接）') {
    return (window.location.href);} else if (paramName == 'url路径名') {
    return (window.location.pathname);} else if (paramName == '主机域名') {
    return (window.location.hostname);} else if (paramName == '主机端口') {
    return (window.location.port);} else if (paramName == '浏览器语言') {
    return (navigator.language);} else {
    return (navigator.platform);}

}
types['methods'].push({
    key: 'SCREEN',
    label: '获取当前屏幕',
    params: [
      {
          key: 'SCREEN',
          label: '的',
          valueType: 'string',
          dropdown: [
    { label: '宽度', value: '宽度', },

    { label: '高度', value: '高度', },

    { label: '可用宽', value: '可用宽', },

    { label: '可用高', value: '可用高', },

    { label: '色深', value: '色深', },
  ],
      },

],
    valueType: 'string',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.SCREEN = function (SCREEN,) {
      if (SCREEN == '宽度') {
    return (screen.width);} else if (SCREEN == '高度') {
    return (screen.height);} else if (SCREEN == '宽度') {
    return (screen.availWidth);} else if (SCREEN == '高度') {
    return (screen.availHeight);} else if (SCREEN == '色深') {
    return (screen.colorDepth);} else {
  }

}
types['methods'].push({
    key: 'CODE',
    label: '转换字符串',
    params: [
      {
          key: 'LABEL',
          label: '字符值',
          valueType: 'string',
          defaultValue: '输入什么吧',
      },
      {
          key: 'STRINGS',
          label: '为',
          valueType: 'string',
          dropdown: [
    { label: 'SHA-1', value: 'SHA-1', },

    { label: 'MD5', value: 'MD5', },

    { label: 'BASE64编码', value: 'BASE64编码', },

    { label: 'Unicode', value: 'Unicode', },

    { label: 'BASE64解码', value: 'BASE64解码', },

    { label: 'URI编码', value: 'URI编码', },

    { label: 'URI解码', value: 'URI解码', },
  ],
      },

],
    valueType: 'string',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.CODE = function (LABEL,STRINGS,) {
      if (STRINGS == 'SHA-1') {
    return (CryptoJS.SHA1(LABEL).toString());} else if (STRINGS == 'MD5') {
    return (CryptoJS.MD5(LABEL).toString());} else if (STRINGS == 'BASE64编码') {
    return (btoa(encodeURI(LABEL)));} else if (STRINGS == 'Unicode') {
    return (escape(LABEL));} else if (STRINGS == 'URI编码') {
    return (encodeURI(LABEL));} else if (STRINGS == 'URI解码') {
    return (decodeURI(LABEL));} else if (STRINGS == 'BASE64解码') {
    return (decodeURI(atob(LABEL)));}

}
types['methods'].push({
    key: 'PACKED',
    label: '判断打包了吗？',
    params: [],
    valueType: 'boolean',
    blockOptions: {
    color: (colourRandom()),
    icon: 'https://ocean.codemao.cn/appcraft/resource/icon/%E5%9F%BA%E7%A1%80/%E6%89%8B%E6%9C%BA.svg',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.PACKED = function () {
      return (utils.isNative());
}
types['methods'].push({
    key: 'RANDOM_COLOR',
    label: '获取随机颜色',
    params: [],
    valueType: 'color',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.RANDOM_COLOR = function () {
      return (colourRandom());
}
types['methods'].push({
    key: 'CURRENT_TIME_STAPE',
    label: '获取当前的',
    params: [
      {
          key: 'time',
          label: '时间值',
          valueType: 'string',
          dropdown: [
    { label: '时间戳', value: '时间戳', },

    { label: '年', value: '年', },

    { label: '月', value: '月', },

    { label: '日', value: '日', },

    { label: '星期', value: '星期', },

    { label: '小时', value: '小时', },

    { label: '分钟', value: '分钟', },

    { label: '秒数', value: '秒数', },

    { label: '毫秒', value: '毫秒', },

    { label: '当前时间（X年X月X日 X时X分X秒）', value: '当前时间（X年X月X日 X时X分X秒）', },
  ],
      },

],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.CURRENT_TIME_STAPE = function (time,) {
      if (time == '时间戳') {
    return (new Date().getTime());} else if (time == '毫秒') {
    return (new Date().getMilliseconds());} else if (time == '年') {
    return (new Date().getFullYear());} else if (time == '月') {
    return (new Date().getMonth());} else if (time == '日') {
    return (new Date().getDate());} else if (time == '小时') {
    return (new Date().getHours());} else if (time == '分钟') {
    return (new Date().getMinutes());} else if (time == '秒数') {
    return (new Date().getSeconds());} else if (time == '当前时间值') {
    return (['',new Date().getFullYear(),'年',new Date().getMonth(),'月',new Date().getDate(),'日',['',new Date().getHours(),'时',new Date().getMinutes(),'分',new Date().getSeconds(),'秒',''].join('')].join(''));}

}
types['methods'].push({
    key: 'REMIX',
    label: '混合颜色',
    params: [
      {
          key: 'COLOR1',
          label: '颜色1',
          valueType: 'color',
          defaultValue: '#33cc00',
      },
      {
          key: 'COLOR2',
          label: '颜色2',
          valueType: 'color',
          defaultValue: '#ffff00',
      },
      {
          key: 'CONFIG',
          label: '混合比例（100%计）',
          valueType: 'number',
          defaultValue: 25,
      },],
    valueType: 'color',
    blockOptions: {
    color: '#33ccff',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.REMIX = function (COLOR1,COLOR2,CONFIG,) {
      return (colourBlend(COLOR1, COLOR2, CONFIG));
}
types['methods'].push({
    key: 'value_export',
    label: '输出',
    params: [
      {
          key: 'num',
          label: '特定数学值',
          valueType: 'string',
          dropdown: [
    { label: '自然常数e', value: '自然常数e', },

    { label: 'π', value: 'π', },

    { label: '随机小数', value: '随机小数', },

    { label: 'φ', value: 'φ', },

    { label: '2^0.5', value: '2^0.5', },

    { label: '2的自然对数', value: '2的自然对数', },
  ],
      },

],
    valueType: 'number',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.value_export = function (num,) {
      if (num == '自然常数e') {
    return (Math.E);} else if (num == 'π') {
    return (Math.PI);} else if (num == '随机小数') {
    return (Math.random());} else if (num == '2^0.5') {
    return (Math.SQRT2);} else if (num == '2的自然对数') {
    return (Math.LN2);} else {
    return ((1 + Math.sqrt(5)) / 2);}

}
types['methods'].push({
    key: 'empty',
    label: '判断是否空文本',
    params: [
      {
          key: 'target',
          label: '内容',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: "",
      },],
    valueType: 'boolean',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.empty = function (target,) {
      return (!target.length);
}
types['methods'].push({
    key: 'round',
    label: '计算圆面积',
    params: [
      {
          key: 'half',
          label: '半径',
          valueType: 'number',
          defaultValue: 8,
      },],
    valueType: 'number',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.round = function (half,) {
      return (Math.PI * Math.pow(half, 2));
}
types['methods'].push({
    key: 'xyproper',
    label: '计算两点XY距离',
    params: [
      {
          key: 'x1',
          label: 'x1',
          valueType: 'number',
          defaultValue: "",
      },
      {
          key: 'y1',
          label: 'y1',
          valueType: 'number',
          defaultValue: "",
      },
      {
          key: 'x2',
          label: 'x2',
          valueType: 'number',
          defaultValue: "",
      },
      {
          key: 'y2',
          label: 'y2',
          valueType: 'number',
          defaultValue: "",
      },],
    valueType: 'number',
    blockOptions: {
    color: (colourRandom()),
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.xyproper = function (x1,y1,x2,y2,) {
      return (Math.pow(Math.pow(x1 - x2, 2) + Math.pow(y1 - y2, 2), 0.5));
}
types['methods'].push({
    key: 'methodName',
    label: '过滤字符串（防止脏话）',
    params: [
      {
          key: 'text_objects',
          label: '文本内容',
          valueType: 'string',
          defaultValue: '这个控件Bug 千千万',
      },],
    valueType: 'string',
    blockOptions: {
    color: (colourRandom()),
    icon: 'https://tse3-mm.cn.bing.net/th/id/OIP-C.NDBxooJbP8tJQdlPF4vllAAAAA?w=216&h=114&c=7&r=0&o=5&dpr=1.3&pid=1.7',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.methodName = function (text_objects,) {
      object = (text_objects.replaceAll('FUCK','*'));
  object = (object.replaceAll('CNM','*'));
  object = (object.replaceAll('WDNMD','*'));
  object = (object.replaceAll('SHIT','*'));
  object = (object.replaceAll('傻逼','*'));
  object = (object.replaceAll('你妈的','*'));
  object = (object.replaceAll('我草','*'));
  object = (object.replaceAll('卧槽','*'));
  object = (object.replaceAll('TMD','*'));
  object = (object.replaceAll('F**K','*'));
  object = (object.replaceAll('RNM','*'));
  object = (object.replaceAll('屌','*'));
  object = (object.replaceAll('日你妈','*'));
  object = (object.replaceAll('个垃圾','*'));
  return object;
}
types['methods'].push({
    key: 'web',
    label: '检查网络状态（好返回True）',
    params: [],
    valueType: 'boolean',
    blockOptions: {
    color: (colourRandom()),
    icon: 'https://ocean.codemao.cn/appcraft/resource/icon/%E5%9F%BA%E7%A1%80/Wi-Fi.svg',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.web = function () {
      return (navigator.onLine);
}
types['methods'].push({
    key: 'convertto16',
    label: '转换16进制',
    params: [
      {
          key: 'NAMEnum',
          label: '数字',
          valueType: 'number',
          defaultValue: "",
      },],
    valueType: 'number',
    blockOptions: {
    color: (colourRandom()),
    icon: '',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.convertto16 = function (NAMEnum,) {
      return ((NAMEnum).toString(16));
}
types['methods'].push({
    key: 'convertto2',
    label: '转换2进制',
    params: [
      {
          key: 'NAMEnum2',
          label: '数值',
          valueType: 'number',
          defaultValue: "",
      },],
    valueType: 'number',
    blockOptions: {
    color: (colourRandom()),
    icon: '',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.convertto2 = function (NAMEnum2,) {
      return ((NAMEnum2).toString(2));
}
types['methods'].push({
    key: 'convertto10',
    label: '转换10进制',
    params: [
      {
          key: 'NAMEnumto10',
          label: '数值',
          valueType: 'number',
          defaultValue: "",
      },],
    valueType: 'number',
    blockOptions: {
    color: (colourRandom()),
    icon: '',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.convertto10 = function (NAMEnumto10,) {
      return ((NAMEnumto10).toString(10));
}
types['methods'].push({
    key: 'uncompile',
    label: '解析字符串',
    params: [
      {
          key: 'typeuncompile',
          label: '内容',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'type',
          label: '类型',
          valueType: 'string',
          dropdown: [
    { label: 'Latin1', value: 'Latin1', },

    { label: 'Hex', value: 'Hex', },

    { label: 'UTF8', value: 'UTF8', },

    { label: 'UTF16', value: 'UTF16', },
  ],
      },

],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: (colourRandom()),
    icon: '',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.uncompile = function (typeuncompile,type,) {
      if (type == 'Latin1') {
    return (CryptoJS.enc.Latin1.parse(typeuncompile));} else if (type == 'Hex') {
    return (CryptoJS.enc.Hex.parse(typeuncompile));} else if (type == 'UTF8') {
    return (CryptoJS.enc.Utf8.parse(typeuncompile));} else if (type == 'UTF16') {
    return (CryptoJS.enc.Utf16.parse(typeuncompile));}

}
types['methods'].push({
    key: 'compile_string',
    label: '字符串化',
    params: [
      {
          key: 'typeuncompile_string',
          label: '内容',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'type',
          label: '类型',
          valueType: 'string',
          dropdown: [
    { label: 'Latin1', value: 'Latin1', },

    { label: 'Hex', value: 'Hex', },

    { label: 'UTF8', value: 'UTF8', },

    { label: 'UTF16', value: 'UTF16', },
  ],
      },

],
    valueType: 'string',
    blockOptions: {
    color: (colourRandom()),
    icon: '',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.compile_string = function (typeuncompile_string,type,) {
      if (type == 'Latin1') {
    return (CryptoJS.enc.Latin1.stringify(typeuncompile_string));} else if (type == 'Hex') {
    return (CryptoJS.enc.Hex.stringify(typeuncompile_string));} else if (type == 'UTF8') {
    return (CryptoJS.enc.Utf8.stringify(typeuncompile_string));} else if (type == 'UTF16') {
    return (CryptoJS.enc.Utf16.stringify(typeuncompile_string));}

}
types['methods'].push({
    key: 'excelfunc',
    label: '使用类似Excel常用函数输出列表值:',
    params: [
      {
          key: 'func',
          label: '列表',
          valueType: ['string','number','boolean','color','array','object'],
          defaultValue: "",
      },
      {
          key: 'typefun',
          label: '类型',
          valueType: 'string',
          dropdown: [
    { label: 'SUM（和）', value: 'SUM（和）', },

    { label: 'MIN（最小）', value: 'MIN（最小）', },

    { label: 'MAX（最大）', value: 'MAX（最大）', },

    { label: '平均值', value: '平均值', },

    { label: '中位数', value: '中位数', },

    { label: '众数（出现频率最高的数）', value: '众数（出现频率最高的数）', },

    { label: '标准差', value: '标准差', },
  ],
      },

],
    valueType: ['string','number','boolean','array','color','object',],
    blockOptions: {
    color: (colourRandom()),
    icon: '',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.excelfunc = function (func,typefun,) {
      if (typefun == 'SUM（和）') {
    return (func.reduce(function(x, y) {return x + y;}));} else if (typefun == 'MIN（最小）') {
    return (Math.min.apply(null, func));} else if (typefun == 'MAX（最大）') {
    return (Math.max.apply(null, func));} else if (typefun == '平均值') {
    return (mathMean(func));} else if (typefun == '中位数') {
    return (mathMedian(func));} else if (typefun == '众数（出现频率最高的数）') {
    return (mathModes(func));} else if (typefun == '标准差') {
    return (mathStandardDeviation(func));}

}
types['methods'].push({
    key: 'angle',
    label: '计算方位角',
    params: [
      {
          key: 'Xangle',
          label: 'X',
          valueType: 'string',
          defaultValue: "",
      },
      {
          key: 'Yangle',
          label: 'Y',
          valueType: 'string',
          defaultValue: "",
      },],

    blockOptions: {
    color: (colourRandom()),
    icon: '',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.angle = function (Xangle,Yangle,) {
      return (Math.atan2(Yangle, Xangle) / Math.PI * 180);
}
// 导出组件的积木汐了，只能这样了
exports.types = types;
exports.widget = Widget;