
var document = globalThis.document
const types = {
    isInvisibleWidget: true,
    type: "COMPRESS_WIDGET",
    icon: "https://creation.codemao.cn/716/appcraft/IMAGE_3NNhA0OxI_1689604069562.png",
    title: "压缩包写入控件",
    auther:"DashedRadius",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [{
        key:"zip",
        label:"压缩算法",
        valueType:"string",
        defaultValue:"deflate",
        dropdown:[
            {label:'deflate',value:"DEFLATE"},
            {label:"简单打包",value:"STORE"}
        ]
    },{
        key:"lv",
        label:"压缩级别(1-9)",
        valueType:"number",
        defaultValue:5
    },{
        key:"platform",
        label:"压缩平台",
        valueType:"string",
        defaultValue:"DOS",
        dropdown:[
            {label:'DOS',value:"DOS"},
            {label:"Unix",value:"UNIX"}
        ]
    }],
    methods: [{
        key:"Zipper",
        label:"创建新的压缩包",
        params:[]
    },{
        key:"destroy",
        label:"停止操作当前压缩包",
        params:[]
    },{
        key:"file",
        label:"创建/修改文本文件",
        tooltip:`必须拥有扩展名;如果加入目录,请用斜杠符号,例如:TEST/A.TXT 为压缩包根目录下TEST下创建A.TXT文件`,
        params:[
            {
               key:"name",
               label:"文件名(建议悬停鼠标获取帮助)",
               valueType:"string",
               defaultValue:"DashedRadius.txt"
            },{
                key:"txt",
                label:"文件内容",
                valueType:"string",
                defaultValue:`
                一堆很长很长的文字.....................................
                `
            }
        ]
    },{
        key:"fileb",
        label:"创建图片/视频等文件",
        tooltip:`必须拥有扩展名;如果加入目录,请用斜杠符号,例如:TEST/A.TXT 为压缩包根目录下TEST下创建A.TXT文件`,
        params:[
            {
               key:"name",
               label:"文件名(建议悬停鼠标获取帮助)",
               valueType:"string",
               defaultValue:"DashedRadius.txt"
            },{
                key:"txt",
                label:"文件内容",
                valueType:"string",
                defaultValue:""
            }
        ]
    },{
        key:"folder",
        label:"新建文件夹",
        params:[{
                key:"txt",
                label:"名称",
                valueType:"string",
                defaultValue:""
        }]
    },{
        key:"rm",
        label:"移除文件(夹)",
        params:[
            {
                key:"txt",
                label:"名称",
                valueType:"string",
                defaultValue:""
            }
        ]
    },{
        key:"output",
        label:"生成压缩文件",
        valueType:"string",
        tooltip:`注意:可能会等待很长时间!`,
        params:[
            {
                key:"txt",
                label:"文件注释",
                valueType:"string",
                defaultValue:""
            }
        ]
    },{
        key:"read",
        label:"请求打开并读取ZIP文件(将替换当前操作的压缩包)",
        params:[]
    },{
        key:"item",
        label:"获取文件名",
        valueType:"string",
        params:[{
            key:"number",
            label:"第几个文件?",
            valueType:"number",
            defaultValue:1
        }]
    },{
        key:"length",
        label:"当前压缩文件压缩文件(夹)数目",
        valueType:"number",
        params:[]
    },{
        key:"readFile",
        label:"根据文件名读取数据",
        valueType:"string",
        params:[{
            key:"number",
            label:"文件名",
            valueType:"string",
            defaultValue:"DashedRadius.txt"
        }]
    }],
    events: [{
        key:"err",
        label:"发生错误",
        params:[{
            key:"name",
            label:"错误消息",
            valueType:"string"
        }]
    },{
        key:"choose",
        label:"选择文件完成",
        params:[]
    }],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        var script = document.createElement("script");
        script.src = "https://unpkg.com/jszip@3.10.1/dist/jszip.js";
        document.body.appendChild(script)
        this.zip = props.zip;
        this.zipinst = undefined;
        this.platform  = props.platform
        this.lv = Number.isInteger(props.lv)&&Number(props.lv) <=9&&Number(props.lv) >0?props.lv:5
    }

    Zipper(){
        if(this.zipinst){this.widgetWarn("已经有压缩包正在操作了!");return;}
        if(!globalThis.JSZip){this.widgetWarn("控件尚未加载完成,请修改积木拼接或等待3秒!");return;}
        this.zipinst = new globalThis.JSZip()
    }

    destroy(){
       this.zipinst = undefined
    }
    
    file(name,txt){
        if(this.zipinst){
            this.zipinst.file(name,txt,{
                createFolders: true
            })
        }
    }

   async fileb(name,txt){
        try{
          const b = await  fetch(txt);
          this.zipinst.file(name,await b.blob(),{
            createFolders: true
        })
        }catch{
            this.widgetWarn('出错了,无法进行压缩');
        }
    }
   
    folder(txt){
        if(this.zipinst){
            this.zipinst.folder(txt)
        }
    }

    rm(txt){
        if(this.zipinst){
            this.zipinst.remove(txt)
        }
    }

output(txt){
return new Promise(resolve =>{
        if(this.zipinst){
            this.zipinst.generateAsync({type:"blob",
            compression:this.zip,
            comment:txt,
            compressionOptions:{
                level:this.lv
            },
        platform:this.platform}).then(blob =>{
               const reader = new FileReader();
               reader.onload = () =>{
                    resolve(reader.result)
               }
               reader.readAsDataURL(blob)
            })
        }
    })
}

read(){
    var input = document.createElement("input")
    input.type = "file"; 
    input.onchange = () =>{
        const files = input.files[0];
        if(!files.type === "application/zip"){this.widgetWarn("非ZIP压缩包读取");this.emit("err","非ZIP压缩包读取");return}
        if(!globalThis.JSZip){this.widgetWarn("控件尚未加载完成,请修改积木拼接或等待3秒!");return;}
        globalThis.JSZip.loadAsync(files).then(zip =>{
            this.zipinst = zip;
            this.emit("choose")
        }).catch(e =>{this.emit("err",e.message);this.widgetWarn(e.message)})
    }
    input.click()
}


item(number = 1){
   if(this.zipinst){
     return (this.zipinst.files[Object.keys(this.zipinst.files)[number-1]]).name
   }
}

length(){
    if(!this.zipinst){return}
    return Object.keys(this.zipinst.files).length
}

async readFile(name){
    if(!this.zipinst)return
   if(!this.zipinst.files[name]){this.widgetWarn("没有这个文件:"+name+"哦");return;}
   if(this.zipinst.files[name].dir){this.widgetWarn('读取到文件夹,请读取文件')}
   const real = await this.zipinst.files[name]["_data"];
   if(typeof real === "string"){
    return real;
   }else if(real instanceof Uint8Array){
      const blob = new Blob([real]);
      return await new Promise(resolve =>{
        var d = new FileReader;
        d.onload = () =>{
            resolve(d.result)
        }
        d.readAsDataURL(blob)
      })
   }
}


}


types["methods"].forEach(value =>{
    value.blockOptions = {
        color:"#566C73",
        icon:types.icon
    }
})

types["events"].forEach(value =>{
    value.blockOptions = {
        icon:types.icon
    }
})

exports.types = types;
exports.widget = Widget;
