var document = this.document;
var window = this.window
const types = {
    isInvisibleWidget: false,
    type: "CANVAS_RECORDABLE_WIDGET",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "可录制画布",
    version: "1.0.0",
    isGlobalWidget: false,
    author:"borderRadius",
    EditTime:"2023/5/1 21:01:54",
    properties: [
      {
        key: '__width',
        label: '宽度',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__height',
        label: '高度',
        valueType: 'number',
        defaultValue: 150,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },{
        key:"backgroundColor",
        label:"背景颜色",
        valueType:"color",
        defaultValue:"#00ffff"
      },{
        key:"br",
        label:"圆角",
        valueType:"number",
        defaultValue:5
      },{
        key:"blur",
        label:"模糊特效大小",
        valueType:"number",
        defaultValue:0
      },{
        key:"bgimg",
        label:"背景图像链接",
        valueType:"string",
        defaultValue:"https://creation.codemao.cn/coco/home/dist/asset/logo_7c0a5.png"
      },{
        key:"sepia",
        label:"黄褐化渲染",
        valueType:"boolean",
        defaultValue:false
      },{
        key:"gray",
        label:"黑白",
        valueType:"boolean",
        defaultValue:false
      }
    ],
    methods: [{
        key:"drawRect",
        label:"绘制矩形",
        params:[{
            key:"a",
            label:"X坐标",
            valueType:"number",
            defaultValue:32
        },{
            key:"b",
            label:"Y坐标",
            valueType:"number",
            defaultValue:12
        },{
            key:"c",
            label:"宽",
            valueType:"number",
            defaultValue:"200"
        },{
            key:"d",
            label:"高",
            valueType:"number",
            defaultValue:"150"
        },{
          key:"e",
          label:"圆角",
          valueType:"number",
          defaultValue:0
        }]
    },{
      key:"pic",
      label:"图像印章",
      params:[{
        key:"img",
        label:"印制图像链接",
        valueType:["image","string"],
        defaultValue:""
      },{
        key:"a",
        label:"X坐标",
        valueType:"number",
        defaultValue:32
    },{
        key:"b",
        label:"Y坐标",
        valueType:"number",
        defaultValue:32
    },{
        key:"c",
        label:"宽",
        valueType:"number",
        defaultValue:"200"
    },{
        key:"d",
        label:"高",
        valueType:"number",
        defaultValue:"150"
    }]
    },{
      key:"txt",
      label:"文本印章",
      params:[{
        key:"text",
        label:"文本",
        valueType:"string",
        defaultValue:"2233awa"
    },{
        key:"b",
        label:"X坐标",
        valueType:"number",
        defaultValue:150
    },{
        key:"c",
        label:"Y坐标",
        valueType:"number",
        defaultValue:"200"
    },{
      key:"size",
      label:"大小",
      valueType:"number",
      defaultValue:16
    },{
      key:"bold",
      label:"粗体",
      valueType:"boolean",
      defaultValue:false
    }]
    },{
      key:"setColors",
      label:"设置颜色",
      params:[{
        key:"a",
        label:"填充色",
        valueType:"color",
        defaultValue:"#0000ff"
    },{
        key:"b",
        label:"边框色",
        valueType:"color",
        defaultValue:"#000000"
    }]    
  },{
  key:"move",
  label:"修改落笔点",
  params:[{
    key:"a",
    label:"X坐标",
    valueType:"number",
    defaultValue:32
},{
    key:"b",
    label:"Y坐标",
    valueType:"number",
    defaultValue:12
}]
},{
  key:"line",
  label:"连线于另一点",
  params:[{
    key:"a",
    label:"X坐标",
    valueType:"number",
    defaultValue:120
},{
    key:"b",
    label:"Y坐标",
    valueType:"number",
    defaultValue:32
}]
},{
  key:"arc",
  label:"绘制圆弧",
  params:[{
    key:"a",
    label:"X坐标",
    valueType:"number",
    defaultValue:22
},{
    key:"b",
    label:"Y坐标",
    valueType:"number",
    defaultValue:52
},{
    key:"c",
    label:"半径",
    valueType:"number",
    defaultValue:20
},{
    key:"d",
    label:"弧度",
    valueType:"number",
   defaultValue:2*Math.PI
},{
  key:"fill",
  label:"填充",
  valueType:"boolean",
  defaultValue:true
}]
},{key:"toDataURL",label:"保存为图片",params:[{key:"q",label:"质量(1-100)",valueType:"number",defaultValue:92}],valueType:"string"} 
,{key:"start",label:"开始录制",params:[{key:"e",label:"帧率",valueType:"number",defaultValue:25}]},
{key:"end",label:"结束录制",params:[]},
{key:"reset",label:"清空",params:[]},

],
    events: [{
        key:"down",
        label:"被点击",
        params:[{
            key:"x",
            label:'画布X坐标',
            valueType:"number"
        },{
            key:"y",
            label:'画布y坐标',
            valueType:"number"
        }]
    },{
      key:"move",
      label:"正在移动",
      params:[{
        key:"x",
        label:'画布X坐标',
        valueType:"number"
    },{
        key:"y",
        label:'画布y坐标',
        valueType:"number"
    },{
      key:"a",
      label:'屏幕X坐标',
      valueType:"number"
  },{
    key:"b",
    label:'屏幕Y坐标',
    valueType:"number"
},{
  key:"movementX",
  label:"移动X坐标",
  valueType:"number"
},{
  key:"movementY",
  label:"移动Y坐标",
  valueType:"number"
}]
    },{key:"up",label:"松开鼠标或手指",params:[{
      key:"x",
      label:'画布X坐标',
      valueType:"number"
  },{
      key:"y",
      label:'画布y坐标',
      valueType:"number"
  }]},{
    key:"data",
    label:"录制完毕",
    params:[{
      key:"v",
      label:"视频文件",
      valueType:"string"
    },{key:"ls",
    label:"临时链接(可播放)",
    valueType:"string"}]
  }],
  };
  
  class Widget extends VisibleWidget {
    constructor(props) {
      super(props);
      this.__width = props.__width;
      this.__height = props.__height;
      this.backgroundColor = props.backgroundColor;
      this.br = props.br;
      this.blur = props.blur;
      this.bgimg = props.bgimg;
      this.sepia = props.sepia;
      this.gray = props.gray;
      this.recorder = undefined
    }
    render() {
      return (<div>
        <style>{`
          @keyframes blur{
            from{
              filter:blur(4px)
            }to{
              filter:blur(${this.blur}px)
            }
          }
        `}
        </style><canvas id="br" 
      onClick={this.onClick.bind(this)}
      onPointerMove={this.onMove.bind(this)}
      onPointerUp={(e)=>{var rect =document.getElementById("br").getClientRects()[0];
      this.emit("up",event.clientX-rect.left,event.clientY-rect.top);}}
      width={this.__width}
      height={this.__height}
      style={{
        backgroundColor:this.backgroundColor,
        borderRadius:this.br,
        transition:"all 0.4s",
        filter:`blur(${this.blur}px) ${this.sepia?"sepia(100%)":""} ${this.gray?"grayscale(100%)":""}`,
        backgroundImage:"url("+this.bgimg+")",
        backgroundRepeat:"no-repeat",
        animation:".5s ease-in-out 0s blur"
      }}></canvas></div>)
    }

    drawRect(a=0,b=0,c=30,d=20,e){
      if(e <= 0){
       document.getElementById("br").getContext("2d").fillRect(a,b,c,d);
      }else{
        document.getElementById('br').getContext('2d').roundRect(a,b,c,d,e)
      }
    }

    onClick =(event)=>{
       var rect =document.getElementById("br").getClientRects()[0];
       this.emit("down",event.clientX-rect.left,event.clientY-rect.top);
    }
    
    onMove = (event) =>{
      var rect =document.getElementById("br").getClientRects()[0];
       this.emit("move",event.clientX-rect.left,event.clientY-rect.top,event.pageX,event.pageY,event.movementX,event.movementY);
    }
    

    pic(img,a,b,c,d){
       var image = document.createElement("img");
       image.src = img;
       image.alt = ""
       image.onerror = () =>this.widgetError("哎呀，加载失败了")
       image.onload = () =>{
         document.getElementById("br").getContext("2d").drawImage(image,a,b,c,d)
       }
       return;
    }

    txt(text,b,c,size,bold){
      document.getElementById("br").getContext('2d').font = `${bold?"bold ":""}${Number(size)}px serif`
       document.getElementById("br").getContext('2d').fillText(text,b,c);
    }

    setColors(a,b){
      document.getElementById("br").getContext('2d').fillStyle = a;
      document.getElementById("br").getContext('2d').strokeStyle = b;
    }

    
    move(a,b){
      document.getElementById('br').getContext('2d').moveTo(a,b)
    }
    line(a,b){
      document.getElementById("br").getContext('2d').lineTo(a,b);
      document.getElementById("br").getContext('2d').stroke();
    }

    arc(a,b,c,d,fill){
      document.getElementById('br').getContext('2d').arc(a,b,c,0,d);
      document.getElementById("br").getContext('2d').stroke();
      if(fill)document.getElementById("br").getContext('2d').fill();
    }

    closePath=()=>document.getElementById("br").getContext('2d').closePath();
    beginPath = () =>document.getElementById("br").getContext('2d').beginPath();
    reset = () =>document.getElementById("br").getContext('2d').reset()
    setPath = e =>document.getElementById("br").getContext('2d').lineWidth = e;
    toDataURL = q =>{try{return document.getElementById("br").toDataURL(q/100)}catch(e){this.widgetError(e.toString())}};
    start = e =>{
       this.recorder = new MediaRecorder(document.getElementById("br").captureStream((Number(e))));
       this.recorder.start();
       this.recorder.ondataavailable = (e) =>{
        var reader = new FileReader();
        reader.onload = ()=>this.emit("data",reader.result,window.URL.createObjectURL(e.data))
        reader.readAsDataURL(e.data)
      }
    }
    end = () =>{if(this.recorder&&this.recorder.state === "recording"){this.recorder.stop()}};
    round = (a,b,c,d,e,f) =>{
      document.getElementById("br").getContext('2d').bezierCurveTo(a,b,c,d,e,f);
      document.getElementById('br').getContext('2d').stroke()
    }
  }
  

types.methods.push({
  key:"beginPath",
  label:"绘制新的路径",
  params:[]
})
types.methods.push({
  key:"closePath",
  label:"闭合路径",
  params:[]
})
types.methods.push({
  key:"setPath",
  label:"设置粗细",
  params:[{key:"e",label:"粗细",valueType:"number",defaultValue:3}]
})
types.methods.push({
  key:"round",
  label:"绘制曲线",
  params:[{
    key:"a",
    label:"X坐标1",
    valueType:"number",
    defaultValue:32
},{
    key:"b",
    label:"Y坐标1",
    valueType:"number",
    defaultValue:12
},{
    key:"c",
    label:"X坐标2",
    valueType:"number",
    defaultValue:36
},{
    key:"d",
    label:"Y坐标2",
    valueType:"number",
    defaultValue:48
},{
  key:"e",
  label:"结束X坐标",
  valueType:"number",
  defaultValue:19
},{
  key:"f",
    label:"结束Y坐标",
    valueType:"number",
    defaultValue:40
}]
})

  exports.types = types;
  exports.widget = Widget;
  