var navigator = this.window.parent.parent.navigator;
var window = this.window;
const types = {
    version:"1.0.0",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "图像粘贴控件",
    type:"CLIPBOARD_BETA_WIDGET",
    isInvisibleWidget: true,
    isGlobalWidget: false,
    properties:[],
    methods: [{
        key:"write",
        label:"写入图像到剪贴板",
        params:[{
            key:"img",
            label:"图像",
            valueType:"string",
            defaultValue:""
        }]
    }],
    events: [],
}

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        
    }

    async write(img){
       if(!img||!img.includes("data:image")||!typeof img === "string"){
        this.widgetError("输入不是图像！")
        return;
       }
       try{
        var a = await window.fetch(img.toString());
        var b = await a.blob();
        var c = new ClipboardItem({
            [b.type]:b
       })
       window.focus()
       navigator.clipboard.write([c]);
       }catch(e){
        throw Error(e)
       }
    }
}

exports.types = types;
exports.widget = Widget;