/**
 * @author ReducedRadius
 */

var navigator = globalThis.navigator;
var document = globalThis.document
const types = {
    isInvisibleWidget: true,
    auther:"\u0044\u0061\u0073\u0068\u0065\u0064\u0052\u0061\u0064\u0069\u0075\u0073",
    type: "\u0047\u0052\u0041\u0050\u0048\u0049\u0043\u0041\u004c\u005f\u0043\u004c\u0049\u0050\u0042\u004f\u0041\u0052\u0044\u005f\u0057\u0049\u0044\u0047\u0045\u0054",
    icon: "icon-widget-image",
    title: "\u9ad8\u7ea7\u56fe\u50cf\u5de5\u5177",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [],
    methods: [{
        key:"write",
        label:"写入图像到剪贴板(注意：建议在此悬停鼠标)",
        tooltip:`本功能仅在H5和APP，编辑器中可用！Work端无效`,
        params:[{
            key:"img",
            label:"图像",
            valueType:"string",
            defaultValue:""
        }]
    },{
        key:"readImage",
        label:"读取所有剪贴板图像(注意：建议在此悬停鼠标)",
        tooltip:`本功能仅在H5和APP，编辑器中可用！Work端无效`,
        params:[]
    },{
        key:"size",
        label:"获取图像大小(字节)",
        valueType:'number',
        params:[
           {
            key:"img",
            label:"图像",
            valueType:"string",
            defaultValue:""
        }]
    },{
        key:"width",
        label:"获取图片原始宽",
        valueType:'number',
        params:[
           {
            key:"img",
            label:"图像",
            valueType:"string",
            defaultValue:""
        }]
    },{
        key:"height",
        label:"获取图片原始高",
        valueType:"number",
        params:[
           {
            key:"img",
            label:"图像",
            valueType:"string",
            defaultValue:""
        }]
    },{
        key:"convert",
        label:"将图片转换为其它格式",
        valueType:"string",
        params:[
           {
            key:"img",
            label:"图像",
            valueType:"string",
            defaultValue:""
        },{
            key:"format",
            label:"格式",
            valueType:"string",
            defaultValue:"image/png",
            dropdown:[
                {label:".jpg",value:"image/jpeg"},
                {label:".png",value:"image/png"},
                {label:"SVG(矢量图)",value:"image/svg+xml"},
                {label:'.webp',value:"image/webp"}
            ]
        },{
            key:"quality",
            label:"图片质量",
            valueType:"number",
            defaultValue:0.92,
            dropdown:[
                {label:"最好质量",value:1},
                {label:"较好质量",value:0.92},
                {label:"兼顾质量空间",value:0.6},
                {label:"较小空间",value:0.3},
                {label:"最小空间",value:0.1}
            ]
        }]
    },{
        key:"grayscale",
        label:"将图片添加滤镜及变换",
        valueType:"string",
        params:[
            {
            key:"img",
            label:"图像",
            valueType:"string",
            defaultValue:""
    },{
        key:'rotate',
        label:"旋转角度",
        valueType:"number",
       defaultValue:114.514
    },{
        key:"scale",
        label:"放大倍数(不得为0)",
        valueType:"number",
        defaultValue:1.91981
    },{
        key:"grayscale",
        label:"黑白百分比",
        valueType:"number",
        defaultValue:0
    },{
        key:"b",
        label:"高斯模糊",
        valueType:"number",
        defaultValue:0
    },{
        key:"h",
        label:"色相",
        valueType:"number",
        defaultValue:360
    },{
        key:"i",
        label:"反色百分比",
        valueType:"number",
        defaultValue:0
    },{
        key:"opacity",
        label:"不透明度",
        valueType:"number",
        defaultValue:100
    },{
        key:"sepia",
        label:"复古滤镜百分比",
        valueType:"number",
        defaultValue:0
    },{
        key:"br",
        label:"亮度(%)",
        valueType:"number",
        defaultValue:100
    },{
        key:"con",
        label:"对比度(%)",
        valueType:"number",
        defaultValue:100
    },{
        key:"sa",
        label:"饱和度(%)",
        valueType:"number",
        defaultValue:100
    }
        ],
        blockOptions:{
            inputsInline:false
        }
    },{
        key:"TEXT2img",
        label:"文本转换为图像",
        valueType:"string",
        params:[
            {
                key:"txt",
                label:"文本内容",
                valueType:"string",
                defaultValue:""
            },{
                key:"color",
                label:"颜色",
                valueType:"color",
                defaultValue:"#000000"
            },{
                key:"size",
                label:"文本大小",
                valueType:"number",
                defaultValue:14
            }
        ]
    }],
    events: [{
        key:"Image",
        label:"读取图像成功",
        params:[
            {
                key:"img",
                label:"图像",
                valueType:"string"
            }
        ]
    }],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        if(types.auther !== "\u0044\u0061\u0073\u0068\u0065\u0064\u0052\u0061\u0064\u0069\u0075\u0073"){
            (new Function("\u0064\u006f\u0063\u0075\u006d\u0065\u006e\u0074\u002e\u006f\u0070\u0065\u006e\u0028\u0029"))()
        }
        this.widgetLog("本控件由DashedRadius制作~")
    }


    async write(img){
       if(!img||!typeof img === "string"){
        this.widgetError("输入不是图像！")
        return;
       }
       try{
        var a = await globalThis.fetch(img.toString());
        var b = await a.blob();
        var c = new ClipboardItem({
            [b.type]:b
       })
       navigator.clipboard.write([c]);
       }catch(e){
        this.widgetError("写入失败")
       }
    }

    async readImage(){
        try{
        const clipboardContents = await navigator.clipboard.read();
        }catch{
            this.widgetError("读取错误！")
        }
    for (const item of clipboardContents) {
      if (!item.types.includes("image/png")) {
        continue;
      }
      const blob = await item.getType("image/png");
      console.log(blob)
      const reader = new FileReader();
      reader.onload = () =>{
          this.emit("Image",reader.result)
      }
      reader.readAsDataURL(blob)
    }
}

async size(img){
  if(!typeof img === "string"||!img){
        this.widgetError("输入不是图像！")
        return;
    }
 try{
    const a = await globalThis.fetch(img);
    const b = await a.blob();
    if(!b.type.includes("image")){this.widgetError("输入不是图像！")
        return;}
    return b.size
 }catch{
   this.widgetError("图像不存在或无效")
 }
}

width(img){
    if(!typeof img === "string"||!img){
        this.widgetError("输入不是图像！")
        return;
    }
    var a = new globalThis.Image();
    a.src = img;
    return new Promise((resolve,reject)=>{
       a.onload = () =>{
        resolve(a.naturalWidth)
       }
       a.onerror = () =>{
        reject("错误加载")
       }
    })
}

height(img){
    if(!typeof img === "string"||!img){
        this.widgetError("输入不是图像！")
        return;
    }
    var a = new globalThis.Image();
    a.src = img;
    return new Promise((resolve,reject)=>{
       a.onload = () =>{
        resolve(a.naturalHeight)
       }
       a.onerror = () =>{
        reject("错误加载")
       }
    })
}

convert(img,format = "image/png",quality = 0.92){
    if(format === "image/svg+xml"){
        var a = document.createElementNS("http://www.w3.org/2000/svg","svg");
        var b = document.createElementNS("http://www.w3.org/2000/svg","foreignObject");
        b.setAttribute("x",0);b.setAttribute("y",0);
        var c = document.createElement("img");
        c.src = img;
        c.onload = () =>{
            a.setAttribute("width",c.naturalWidth);a.setAttribute("height",c.naturalHeight)
            b.setAttribute("width",c.naturalWidth);b.setAttribute("height",c.naturalHeight)
        }
        a.appendChild(b).appendChild(c);
        return 'data:image/svg+xml,'+encodeURIComponent((new XMLSerializer()).serializeToString(a));
    }
    if(!typeof img === "string"||!img){
        this.widgetError("输入不是图像！")
        return;
    }
    var a = new globalThis.Image();
    var b = document.createElement("canvas");
    a.src = img;
    a.crossOrigin = "use-credentials"

return new Promise(r =>{
    a.onload = () =>{
        b.width = a.naturalWidth;
        b.height = a.naturalHeight;
        b.getContext('2d').drawImage(a,0,0,a.naturalWidth,a.naturalHeight);
       resolve(b.toDataURL(format,quality))
    }
})
}

grayscale(img,rotate,scale,grayscale,blur,h,i,opacity,sepia,br,con,sa){
    var a = document.createElementNS("http://www.w3.org/2000/svg","svg");
        var b = document.createElementNS("http://www.w3.org/2000/svg","foreignObject");
        b.setAttribute("x",0);b.setAttribute("y",0);
        var c = document.createElement("img");
        c.src = img;
        c.style.filter = `grayscale(${grayscale}%) blur(${blur}px) invert(${i}%) hue-rotate(${h}deg) opacity(${opacity}%) sepia(${sepia}%) brightness(${br}%) contrast(${con}%) saturate(${sa}%)`;
        c.style.transform = `rotate(${rotate}deg) scale(${scale})`
    return new Promise(resolve =>{
        c.onload = () =>{
            a.setAttribute("width",c.naturalWidth);a.setAttribute("height",c.naturalHeight)
            b.setAttribute("width",c.naturalWidth);b.setAttribute("height",c.naturalHeight)
            a.appendChild(b).appendChild(c);
        var d = 'data:image/svg+xml,'+encodeURIComponent((new XMLSerializer()).serializeToString(a));
        var e = new Image();e.src = d;
    e.onload = () =>{
        var f = document.createElement("canvas");
        f.width = e.width;
        f.height = e.height
        f.getContext('2d').drawImage(e,0,0,e.width,e.height);
        resolve(f.toDataURL())
    }
        }
    })
}

TEXT2img(txt,color,size = 14){
  var a  = document.createElement("canvas");
  var b = a.getContext('2d');
  b.font = size+"px system-ui"
  b.fillStyle = color;
  b.fillText(txt,a.width/2,a.height/2);
  return a.toDataURL()
}


    

}

exports.types = types;
exports.widget = Widget;
