// 2024.8.2更新
var window  = this.window;
const types = {
    isInvisibleWidget: true,
    type: "FILE_PLUS_WIDGET",
    icon: "https://creation.codemao.cn/716/appcraft/IMAGE_M9eND0YsW_1682132314408.png",
    title: "文件修改",
    version: "1.0.0",
    platforms:["web"],
    author:"ReducedRadius",
    completeTime:"23/4/21 22:25",
    docs:{url:"https://reducedradius.netlify.app/widget"},
    isGlobalWidget: true,
    properties: [{
        key:"usemap",
        label:"使用说明",
        valueType:"string",
        editorType:"TextArea",
        defaultValue:`注意：本控件只适用于电脑端，且要求极高，必须是Chrome最新版（110）\n
        才可使用！！！;`
    }],
    methods: [{
        key:"readFile",
        label:"请求打开文件",
        params:[{
            key:"showall",
            label:"不显示‘所有’文件",
            valueType:"boolean",
            defaultValue:false
        },{
            key:"des",
            label:"文件类型描述",
            valueType:"string",
            defaultValue:""
        },{
            key:"z",
            label:"文件类别",
            valueType:"string",
            dropdown:[{
value:"audio/*",
label:"音频",
},{label:'图片',value:"image/*"},
{label:"MP4",value:"video/mp4"},
{label:"MP3",value:"audio/mp3"},
{label:"PNG",value:"image/png"},
{label:"JPG",value:"image/jpeg"},
{label:"TXT",value:'text/plain'},
{label:"文本类型",value:"text/*"},
{label:"其他",value:"application/*"}
]
        },{
            key:"b",
            label:'文件扩展名列表',
            valueType:"string",
            defaultValue:".png,.gif"
        }]
    },{
        key:"remove",
        label:"删除文件",
        params:[{
            key:'a',
            label:"文件",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        }]
    },{
        key:"readAsRes",
        label:'读取为资源数据链接',
        params:[{
            key:'a',
            label:"文件",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        }]
    },{
        key:"readAsText",
        label:"读取为文本",
        params:[{
            key:'a',
            label:"文件",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        }]
    },{
        key:"save",
        label:'打开保存对话框并等待',
        params:[]
    },{
        key:"writeText",
        label:"写入文本到文件",
        params:[{
            key:"file",
            label:"文件",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        },{
            key:"Strings",
        label:"写入的文本",
            valueType:"string",
            defaultValue:""
        }]
    },{
        key:"writeImage",
        label:'写入图像到文件',
        params:[{
            key:"file",
            label:"文件",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        },{
            key:"Strings",
            label:"将要写的图片(链接)",
            valueType:"string",
            defaultValue:""
        }]
    },{
        key:"isCompletelySupport",
        label:'是否支持使用本控件',
        valueType:"boolean",
        params:[]
    },{
        key:"isSameFile",
        label:'两个文件是不是一样的？',
        valueType:"boolean",
        params:[{
            key:"a",
            label:"文件1",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        },{
            key:"b",
            label:"文件2",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        }]
    },{
        key:"getName",
        label:"获取文件名称",
        params:[
            {
                key:"a",
                label:"文件",
                valueType:["object","string","array","number","boolean"],
                defaultValue:""
            }
        ],
        valueType:"string"
    },{
        key:"readDir",
        label:"请求读取目录并返回文件列表",
        params:[],
        valueType:"array"
    },{
      key:"isDirectory",
      label:"这个资源是文件夹？",
      params:[{
        key:"a",
        label:"资源",
        valueType:["object","string","array","number","boolean"],
        defaultValue:""
      }],
      valueType:"boolean"
    },{
        key:"show",
        label:"打开文件夹并读取里面文件和目录",
        params:[{
            key:"a",
            label:"文件夹",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
          }],
        valueType:"array"
    },{
        key:"getfileByName",
        label:'获取文件夹中命名的文件',
        params:[{
            key:"dir",
            label:"文件夹",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        },{
            key:"name",
            label:'将要获取的名称',
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        }]
    },{
        key:"write2bits",
        label:"写入二进制数据到文件",
        params:[{
            key:"file",
            label:"文件",
            valueType:["object","string","array","number","boolean"],
            defaultValue:""
        },{
            key:"object",
            label:"写入内容列表",
            valueType:["object","array","string","number"],
            defaultValue:""
        }]
    }],
    events: [{
        key:'end',
        label:"读取或保存文件完毕",
        params:[{
            key:'file',
            label:"可修改文件",
            valueType:["object","string","array","number","boolean"]
        }]
    },{
        key:"success",
        label:"修改操作成功",
        params:[{
            key:"result",
            label:'输出结果',
            valueType:["object","string","array","number"]
        },{
            key:"origin",
            label:"结果来源",
            valueType:"string"
        }]
    },{
        key:"fail",
        label:"修改操作失败",
        params:[{
            key:"err",
            label:'错误信息',
            valueType:"string"
        }]
    }],
};



class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        if(!"showOpenFilePicker" in window){
          this.widgetError("浏览器不支持！");
          return;
        }
    }
   async readFile(showall=false,des="任意的文件~",z,b=String(".png,.gif")){
       var handle = await window.showOpenFilePicker({
            types: [
                {
                  description: des,
                  accept: {
                    [z]:b.split(",")
                  },
                },
              ],
              excludeAcceptAllOption:showall
        })
        this.emit("end",handle[0])
    }

    remove(a){
       if(a.remove) a.remove().then(e =>{
        this.emit("success","成功删除O(∩_∩)O~~","删除文件操作")
       }).catch(e =>{
         this.emit("fail",e)
       })
       else{
        this.widgetError("非文件或浏览器不支持")
        console.log(a)
       } 
    }


    readAsRes(a){
          if(a.getFile) var z =a.getFile().then((e=new Blob([""])) =>{
             var reader = new FileReader();
             reader.onload = () =>{this.emit("success",reader.result,"资源数据链接读取完毕")}
             reader.readAsDataURL(e)
          }).catch(e =>{
              this.emit("fail",e)
          })

    }
    readAsText(a){
        if(a.getFile) var z =a.getFile().then((e=new Blob([""])) =>{
           var reader = new FileReader();
           reader.onload = () =>{this.emit("success",reader.result,"文本读取完毕")}
           reader.readAsText(e)
        }).catch(e =>{
            this.emit("fail",e)
        })

  }
  async save(){
     var n = await window.showSaveFilePicker();
     this.emit("end",n)
  }

 async writeText(file,Strings){
    try{
   if(file.createWritable){
    var a = await file.createWritable();
    a.write(Strings).then(e =>{
        console.log("233")
        a.close()
    }).catch(e =>{
        throw e;
    });
   }else{
     console.log(file)
   }
   this.emit("success",`写入成功O(∩_∩)O~~`,"文本写入")
  }catch(e){
    this.emit("fail",e)
  }
}


async writeImage(file,Strings){
    try{
        if(file.createWritable){
         var a = await file.createWritable();
         var s = await window["fet"+"c"+"h"](Strings);
         var d = await d.blob()
         a.write(d).then(e =>{
             console.log("233")
             a.close()
         }).catch(e =>{
             throw e;
         });
        }else{
          console.log(file)
        }
        this.emit("success",`写入图片成功O(∩_∩)O~~`,"图片写入")
       }catch(e){
         this.emit("fail",e)
       }
}

get usemap(){
    return `注意：本控件只适用于电脑端，且要求极高，必须是Chrome最新版（110）\n
    才可使用！！！;控件版本：Beta`
}
set usemap(as){
    window.alert('你不知道你改成“'+as+'”我的心会怎样吗？？？(*￣︿￣)这个不可以改！！！')
}

isCompletelySupport(){
    var rm =FileSystemHandle.prototype.remove;
    var zm = window.showOpenFilePicker;
    var dd = FileSystemFileHandle.prototype.createWritable;
    var cc = widow.showDirectoryPicker
    if(dd&&rm&&zm&cc)return true 
    else{return false}
}

async isSameFile(a,b){
  if(a.isSameEntry){
    return await a.isSameEntry(b)
  }else{
    this.widgetError("第一个参数不是文件")
  }

}

getName(a){
 return a.name
}

async readDir(){
    var m = [];
 var aff = await window.showDirectoryPicker();
 for await(let j of aff.values()){
    m.push(j)
 };
 return m;
}
isDirectory(a){
    return a.kind === "directory"?true:false
}
async show(a){
    var m = [];
    if(!a.kind === "directory")
    {this.widgetError("这不是文件夹");return;}
    for await(let j of a.values()){
        m.push(j)
     }
     return m;
}

async getfileByName(dir,name=""){
  if(!dir.kind === "directory")return;
  try{var check = await dir.getFileHandle(name);}catch(e){this.emit("fail",e)}
  return check;
}

async write2bits(file,object){
  if(!file.createWritable)return;
  var a = await file.createWritable();
  if(Array.isArray(object)){
    var binary = new DataView(new ArrayBuffer(object.length))
    object.forEach((e,num) =>{
        if(isNaN(e)){this.widgetError("非数值于列表第"+num+"项--写入二进制数据");return;}
        else if(e<0||e>=256){return;}
        else if(!Number.isInteger(e)){return;}
        else{
         binary.setUint8(num,Number(e))
        }
    });
    a.write(binary).then(e =>{
        a.close();
        this.emit("success",`${new Date().toLocaleString("zh-CN")}时写入成功`,'文件二进制写入成功！')
    })
  }else{
    return;
  }
}

}

exports.types = types;
exports.widget = Widget;

