var window = globalThis;
var document = globalThis.document;
const types = {
    isInvisibleWidget: true,
    type: "DR_SELECTION_WIDGET",
    icon: "icon-widget-text",
    title: "文本选择感应控件",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [],
    methods: [{
        key:"getText",
        label:"获取选择文本内容",
        valueType:"string",
        params:[]
    },{
        key:"clear",
        label:"清除选择",
        params:[]
    },{
        key:"del",
        label:"删除选定内容",
        params:[]
    },{
        key:"extend",
        label:"修改选择内容",
        tooltip:"",
        params:[
            {
                key:"add",
                label:"从当前处往右下方向修改？",
                valueType:"boolean",
                defaultValue:true
            },{
                key:"mod",
                label:"修改量",
                valueType:'string',
                defaultValue:"character",
                dropdown:[
                    {label:"一个字",value:"character"},
                    {label:"一组词",value:"word"},
                    {label:"一句话",value:"sentence"},
                    {label:"一行",value:"line"},
                    {label:"段落",value:"paragraph"},
                    {label:"从选择处开始到结尾",value:"documentboundary"},
                    {label:"从选择处开始到本行结尾",value:"lineboundary"}
                ]
            }
        ]
    },{
        key:"disable",
        label:"屏幕禁止选择",
        params:[]
    },{
        key:"enable",
        label:"屏幕允许选择",
        params:[]
    },{
        key:"isSelected",
        label:"是否选择了内容？",
        valueType:"boolean",
        params:[]
    }],
        
    events: [{
        key:"selection",
        label:"选择内容改变",
        params:[]
    }],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        if(!window.getSelection){return;}
        document.onselectionchange = () =>{
            this.emit("selection")
        }
    }

    getText(){
        return window.getSelection().toString()
    }

    clear(){
        window.getSelection().empty()
    }

    del(){
        window.getSelection().deleteFromDocument()
    }

    extend(add,mod){
        window.getSelection().modify("extend",add?"forward":"backward",mod)
    }

    disable(){
        document.documentElement.style.userSelect = "none"
    }

    enable(){
        document.documentElement.style.userSelect = "auto"
    }

    isSelected(){
        return document.getSelection().type === "Range"
    }
    
   
}

exports.types = types;
exports.widget = Widget;
