/**
 * @author ReducedRadius
 */

function colourRandom() {
  var num = Math.floor(Math.random() * Math.pow(2, 24));
  return '#' + ('00000' + num.toString(16)).substr(-6);
}



const types = {
  isInvisibleWidget: false,
  type: "POP_WIDGET",
  icon: "https://ocean.codemao.cn/appcraft/resource/icon/%E5%9F%BA%E7%A1%80/%E7%9A%AE%E8%82%A4.svg",
  title: "气泡框",
  version: "1.0.0",
  isGlobalWidget: false,
  properties: [
    {
      key: '__width',
      label: '宽度',
      valueType: 'number',
      defaultValue: 188,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__height',
      label: '高度',
      valueType: 'number',
      defaultValue: 140,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__size',
      label: '',
      valueType: 'number',
      defaultValue: 0,
      readonly: true,
      blockOptions: {
        setter: {
          keys: ['__height', '__width'],
        },
        getter: {
          keys: ['__height', '__width'],
        },
      },
    },
  ],
  methods: [],
  events: [],
};

class Widget extends VisibleWidget {
  constructor(props) {
    super(props);
    this.__width = props.__width;
    this.__height = props.__height;
    this.content=props.content;
  this.radius=props.radius;
  this.colors=props.colors;
  this.left=props.left;
  this.up=props.up;
  this.font=props.font;
  this.fontleft=props.fontleft;
  this.fontup=props.fontup;
  this.border=props.border;
  this.borderwidth=props.borderwidth;
  this.fontSize=props.fontSize;
  this.opacity=props.opacity;
  this.editable=props.editable;
  this.image=props.image;

  }
  render() {
    return(
      React.createElement("div", {  disabled: (this.editable),
      style: {  opacity: (this.op),
      },
    }, [React.createElement("div", {  onClick: this.onClick.bind(this),
        onBlur: this.onblur.bind(this),
        onDoubleClick: this.onDoubleClick.bind(this),
        onMouseOut: this.onmouseout.bind(this),
        style: {  width: "100%",
          minWidth: '32px',
          minHeight: '32px',
          borderRadius: (this.radius),
          backgroundImage: ('url(' + String(String(this.image) + ')')),
          backgroundColor: (this.colors),
          transition: 'all 0.3s ease-in-out',
          color: (this.font),
          left: (String(this.fontleft) + '%'),
          bottom: (String(this.fontup) + '%'),
          position: 'absolute',
          borderColor: (this.border),
          borderWidth: (this.borderwidth),
          fontSize: (this.fontSize),
        },
      }, [(this.content)]),
      React.createElement("svg", {  style: {  transition: 'all 0.3s ease-in-out',
          left: (String(this.left) + '%'),
          bottom: (String(this.up) + '%'),
          position: 'absolute',
        },
      }, [React.createElement("path", {  d: 'M 6.343145750507619 8 A 4 4 0 0 0 9.17157287525381 6.82842712474619 L 14.585786437626904 1.414213562373095 A 2 2 0 0 1 17.414213562373096 1.414213562373095 L 22.82842712474619 6.82842712474619 A 4 4 0 0 0 25.65685424949238 8 Z',
          fill: (this.colors),
          stroke: (this.border),
          strokeWidth: (this.borderwidth),
          style: {  transition: 'all 0.3s ease-in-out',
          },
        }, []),]),])
  );

  }
}

types['properties'].push({
    key: 'content',
    label: '文案',
    valueType: 'string',
    editorType: 'TextArea',
    defaultValue: '请输入消息内容...',

})

types['properties'].push({
    key: 'radius',
    label: '圆角',
    valueType: 'number',
    defaultValue: 8,

})

types['properties'].push({
    key: 'colors',
    label: '背景颜色',
    valueType: 'color',
    defaultValue: '#996633',

})

types['properties'].push({
    key: 'border',
    label: '底部边缘颜色',
    valueType: 'color',
    defaultValue: '#cc6600',

})

types['properties'].push({
    key: 'borderwidth',
    label: '底部边缘大小',
    valueType: 'number',
    defaultValue: 2,

})

types['properties'].push({
    key: 'left',
    label: '气泡角右偏百分比',
    valueType: 'number',
    defaultValue: 40,

})

types['properties'].push({
    key: 'up',
    label: '气泡角下偏百分比',
    valueType: 'number',
    defaultValue: (-46),

})

types['properties'].push({
    key: 'font',
    label: '字体颜色',
    valueType: 'color',
    defaultValue: '#cccccc',

})

types['properties'].push({
    key: 'fontSize',
    label: '字体大小',
    valueType: 'number',
    defaultValue: 14,

})

types['properties'].push({
    key: 'fontleft',
    label: '文本框内右偏',
    valueType: 'number',
    defaultValue: 0,

})

types['properties'].push({
    key: 'fontup',
    label: '文本框内上偏',
    valueType: 'number',
    defaultValue: 60,

})

types['properties'].push({
    key: 'op',
    label: '不透明度（输入小数）',
    valueType: 'number',
    defaultValue: 0.9,

})

types['properties'].push({
    key: 'editable',
    label: '禁用',
    valueType: 'boolean',
    defaultValue: false,

})

types['properties'].push({
    key: 'image',
    label: '背景图片链接',
    valueType: 'string',
    editorType: 'TextArea',
    defaultValue: 'https://ocean.codemao.cn/appcraft/resource/icon/%E5%9F%BA%E7%A1%80/%E6%90%9C%E7%B4%A21.svg',

})

types['methods'].push({
    key: 'methodName',
    label: '渐显气泡框',
    params: [],

    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.methodName = function () {
      setTimeout(((()=>{  this.setProps({ 'op': 0 });
  })),50);
  setTimeout(((()=>{  this.setProps({ 'op': 0.1 });
  })),100);
  setTimeout(((()=>{  this.setProps({ 'op': 0.2 });
  })),150);
  setTimeout(((()=>{  this.setProps({ 'op': 0.3 });
  })),200);
  setTimeout(((()=>{  this.setProps({ 'op': 0.4 });
  })),250);
  setTimeout(((()=>{  this.setProps({ 'op': 0.5 });
  })),300);
  setTimeout(((()=>{  this.setProps({ 'op': 0.6 });
  })),350);
  setTimeout(((()=>{  this.setProps({ 'op': 0.7 });
  })),400);
  setTimeout(((()=>{  this.setProps({ 'op': 0.8 });
  })),450);
  setTimeout(((()=>{  this.setProps({ 'op': 0.9 });
  })),500);
  setTimeout(((()=>{  this.setProps({ 'op': 1 });
  })),550);

}
types['methods'].push({
    key: 'colkor',
    label: '变色',
    params: [],

    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
},
})
Widget.prototype.colkor = function () {
      setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),100);
  setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),200);
  setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),300);
  setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),400);
  setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),500);
  setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),600);
  setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),700);
  setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),800);
  setTimeout(((()=>{  this.setProps({ 'colors': (colourRandom()) });
  })),900);

}
types['events'].push({
    key: 'onClick',
    label: '被点击',
    params: [],

})
Widget.prototype.onClick = function (event) {
      this.emit("onClick");
}

types['events'].push({
    key: 'onblur',
    label: '失去焦点',
    params: [],

})
Widget.prototype.onblur = function (event) {
      this.emit("onblur");
}

types['events'].push({
    key: 'onDoubleClick',
    label: '气泡被双击',
    params: [],

})
Widget.prototype.onDoubleClick = function (event) {
      this.emit("onDoubleClick");
}

types['events'].push({
    key: 'onmouseout',
    label: '触碰点离开气泡',
    params: [],

})
Widget.prototype.onmouseout = function (event) {
      this.emit("onmouseout");
}

exports.types = types;
exports.widget = Widget;
