// 控件修改于2023年11月18日
const types = {
  isInvisibleWidget: false,
  type: "FILE_DRAG_MGR_WIDGET",
  icon: "https://ocean.codemao.cn/appcraft/resource/icon/%E5%9F%BA%E7%A1%80/%E6%96%87%E4%BB%B6%E5%A4%B9_%E5%85%B3.svg",
  title: "文件拖放框",
  auther:"ReducedRadius",
  version: "1.0.0",
  isGlobalWidget: false,
  properties: [
    {
      key: '__width',
      label: '宽度',
      valueType: 'number',
      defaultValue: 200,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__height',
      label: '高度',
      valueType: 'number',
      defaultValue: 150,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__size',
      label: '',
      valueType: 'number',
      defaultValue: 0,
      readonly: true,
      blockOptions: {
        setter: {
          keys: ['__height', '__width'],
        },
        getter: {
          keys: ['__height', '__width'],
        },
      },
    },{
      key:"content",
      label:"内容",
      valueType:"string",
      editorType:"TextArea",
      defaultValue:"请拖入文件至此"
    },{
      key:"border",
      label:"边框样式",
      valueType:"string",
      defaultValue:"dashed",
      dropdown:[
        {label:"虚线",value:"dashed"},
        {label:"实线",value:"solid"},
        {label:"点状线",value:"dotted"},
        {label:"双线",value:"double"}
      ]
    },{
      key:"bw",
      label:"边框大小",
      valueType:"number",
      defaultValue:1,
      unit:"像素"
    },{
      key:"br",
      label:"圆角值",
      valueType:"number",
      defaultValue:1,
      unit:"像素"
    },{
      key:"bc",
      label:"边框色",
      valueType:"color",
      defaultValue:"#000000"
    },{
      key:"bgc",
      label:'背景色',
      valueType:"color",
      defaultValue:"#ffffff"
    },{
      key:"tc",
      label:"文本色",
      valueType:"color",
      defaultValue:"#000000"
    },{
      key:"tl",
      label:"文本左右位置",
      valueType:"number",
      defaultValue:52,
      unit:"像素"
    },{
      key:"tlb",
      label:"文本上下位置",
      valueType:"number",
      defaultValue:64,
      unit:"像素"
    },{
      key:"fs",
      label:"字体大小",
      valueType:"number",
      defaultValue:14,
      unit:"像素"
    },{
      key:"space",
      label:"文本间距",
      valueType:"number",
      defaultValue:0,
      unit:"像素"
    },{
      key:"s",
      label:"框大小",
      valueType:"number",
      defaultValue:100,
      unit:"%"
    },{
      key:"shadow",
      label:'框阴影大小',
      valueType:"number",
      defaultValue:1,
      unit:"像素"
    }
  ],
  methods: [{
    key:"con",
    label:"文件链接转换为文本",
    valueType:"string",
    params:[{key:"a",label:"文件链接",valueType:"string",defaultValue:""}]
  },{
    key:"canPlay",
    label:"类型能否播放？",
    valueType:"boolean",
    params:[{key:"a",label:"Mime类型",valueType:"string",defaultValue:""}]
  }],
  events: [{
    key:"drop",
    label:"文件拖放到框内",
    params:[{
        key:"file",
        label:"文件链接",
        valueType:"string",
    },{
      key:"text",
      label:"是文本文件?",
      valueType:"boolean"
    },{
      key:"not",
      label:"文件类型未知？",
      valueType:"boolean"
    },{
      key:"size",
      label:"文件大小(KB)",
      valueType:"number"
    },{
      key:"name",
      label:"文件名",
      valueType:"string"
    },{
      key:"date",
      label:"修改时间",
      valueType:"string"
    },{
      key:"mime",
      label:"文件Mime类型",
      valueType:"string"
    }]
  },{
    key:"will",
    label:"将放下文件",
    params:[]
  },{
    key:"move",
    label:"手或鼠标在框内移动",
    params:[]
  },{
    key:"click",
    label:'被点击',
    params:[]
  }],
};

class Widget extends VisibleWidget {
  constructor(props) {
    super(props);
    this.__width = props.__width;
    this.__height = props.__height;
    this.content = String(props.content)
    this.border = props.border;
    this.shadow = props.shadow;
    this.bw= props.bw;
    this.br = props.br;
    this.bc = props.bc;
    this.bgc = props.bgc;
    this.tc = props.tc;this.tl =props.tl;this.tlb = props.tlb;this.fs = props.fs;
    this.space =props.space;
    this.s=props.s;
  }
  render() {
    return(
        <div onDrop={this.ondrop.bind(this)} onDragOver={(event)=>{event.preventDefault();this.emit("will")}}
        onMouseMove={()=>{this.emit('move')}} onClick={(event)=>{this.emit("click")}} style={{
          width:this.__width,
          height:this.__height,
          borderStyle:this.border,
          borderWidth:this.bw,
          borderRadius:this.br,
          borderColor:this.bc,
          backgroundColor:this.bgc,
          fontSize:this.fs,
          color:this.tc,
          transform:`scale(${this.s/100})`,
          boxShadow:`0 0 ${this.shadow}px 4px`,
          letterSpacing:this.space
        }}><span style={{
           position:"absolute",
           left:this.tl,
           top:this.tlb
        }}>{this.content}</span></div>
    )
  }

  ondrop = (event) =>{
    event.preventDefault();
    const data = event.dataTransfer.files;
    if(data.length === 0){return;}
    else{
    const m = Array.from(data);
    m.forEach(v =>{
        var reader = new FileReader();
        reader.onload = e =>{
          this.emit("drop",reader.result,v.type.includes("text/"),v.type === "",
          v.size/1024,v.name,new Date(v.lastModified).toLocaleString(),v.type)
        }
        reader.readAsDataURL(v)
    })
    }
  }

  async con(a){
    const data = globalThis.atob((a.split(","))[1]);
    var Arr = [];
    for(var i=0;i<data.length;i++){
      Arr.push(data[i].charCodeAt())
    }
    return await (new Blob([new Uint8Array(Arr)])).text();
  }

  canPlay(a){
    var b = globalThis.document.createElement("video");
    return b.canPlayType(a) === ""?false:true
  }


}

exports.types = types;
exports.widget = Widget;
