var navigator = globalThis.navigator
var window = globalThis
const types = {
    isInvisibleWidget: true,
    type: "NETWORK_INFO_WIDGET",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "网络监测控件",
    auther:"DashedRadius",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [],
    methods: [{
        key:"speed",
        tooltip:`注意,即使您的网速大于10MB/S(宽带>100Mbps),系统也最多显示10MB/S`,
        label:"获取当前网速(MB/S)",
        valueType:"number",
        params:[]
    },{
        key:"high",
        label:"网络是否为4G及以上?",
        params:[],
        valueType:"boolean"
    },{
        key:"rtt",
        tooltip:`即当前连接下评估的往返时延（RTT, round-trip time）`,
        label:"获取数据传输往返所需时间(毫秒)",
        params:[],
        valueType:"number"
    },{
        key:"saveData",
        label:"限制了数据传输?",
        params:[],
        valueType:"boolean"
    },{
        key:"addCache",
        label:"添加网页内容到缓存",
        params:[{key:"v",label:"网页链接",valueType:"string",defaultValue:window.location.href}]
    },{
        key:"match",
        label:"获取缓存文本内容",
        params:[
            {key:"v",label:"对应链接",valueType:"string",defaultValue:""}
        ],
        valueType:"string"
    },{
        key:"all",
        label:"所有缓存的链接列表",
        params:[],
        valueType:["array","string"]
    },{
        key:"del",
        label:"删除缓存内容",
        params:[
            {key:"v",label:"对应链接",valueType:"string",defaultValue:""}
        ]
    },{
        key:"bytes",
        label:'缓存存储占用字节总数',
        params:[],
        valueType:"number"
    },{
        key:"rest",
        label:"使用本应用存储剩余空间(字节)",
        params:[],
        valueType:"number"
    }],
    events: [{
        key:"change",
        label:"检测到网络状态变化",
        params:[]
    },{
        key:"offline",
        label:"检测到断网",
        params:[]
    },{
        key:"online",
        label:"网络恢复正常",
        params:[]
    },{
        key:"caerr",
        label:"缓存操作错误",
        params:[
            {key:"a",label:"错误消息",valueType:"string"}
        ]
    },{
        key:"casuc",//cache success缩写
        label:"缓存操作成功",
        params:[
            {key:"a",label:"加入缓存的URL",valueType:"string"}
        ]
    }],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        if(!window.caches){this.widgetError("您的浏览器不支持使用本控件!");return}
        if(!navigator.connection){this.widgetError("您的浏览器不支持使用本控件!");return}
        this.cache = null;
        window.caches.open("DashedRadiusCache_Box").then((e)=>{
            this.cache = e
        })
        navigator.connection.onchange = () =>{
           this.emit("change")
        }
        window.onoffline = () =>{
            this.emit("offline")
        }
        window.ononline = () =>{
            this.emit("online")
        }
    }

    speed(){return navigator.connection.downlink}
    high(){return navigator.connection.effectiveType === "4g"}
    rtt(){return navigator.connection.rtt}
    saveData(){return navigator.connection.saveData}
    addCache(v){if(this.cache){
        this.cache.add(v).then(e =>{
           this.emit("casuc",v)
        },e =>{
            this.emit("caerr",e)
        })
    }}
 async match(v){
        const a =  await this.cache.match(v)
        return await a.text()
    }
  async all(){ if(this.cache){
    var b = [];
    const a  = await this.cache.keys();
     a.forEach(e =>{
      b.push(e.url)
     })
     while(a.length === b.length){
        return b;
     }
}}
  del(v){if(this.cache){
    this.cache.delete(v).then(e =>{
        this.emit("casuc",v)
    },e =>{
        this.emit("caerr",e)
    })
  }}

 async bytes(){
    if(navigator.storage){
       var a = await  navigator.storage.estimate();
       return a.usageDetails.caches?a.usageDetails.caches:0
    }
 }
 async rest(){
    if(navigator.storage){
        var b = await navigator.storage.estimate();
        return b.quota-b.usage
    }
 }
}

exports.types = types;
exports.widget = Widget;
