var navigator = globalThis.navigator;

const types = {
    isInvisibleWidget: true,
    type: "BLUETOOTH_WIDGET",
    icon: "icon-toolbox-feature",
    title: "蓝牙控件(仅电脑端)",
    author:"Dashedadius",
    edit:"2023-6-16",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [{
        key:"caution",
        label:"注意",
        valueType:"string",
        editorType:"TextArea",
        defaultValue:"该控件较为专业，且只能用此方法调用蓝牙\n 相关英文文档见https://btprodspecificationrefs.blob.core.windows.net/assigned-numbers/Assigned%20Number%20Types/Assigned_Numbers.pdf \n"
    }],
    methods: [{
        key:"request",
        label:'请求获取蓝牙设备',
        params:[],
        blockOptions:{
            line:"第一步"
        }
    },{
        key:"getService",
        label:"获取蓝牙服务",
        params:[],
        blockOptions:{
            line:"第二步"
        }
    },{
        key:"eject",
        label:"断开设备连接",
        params:[]
    },{
        key:"getChar",
        label:"获取所有相关‘属性’",
        params:[{
            key:"uuid",
            label:"属性编号",
            valueType:"string",
            defaultValue:"00002a73-0000-1000-8000-00805f9b34fb"
        }],
        blockOptions:{
           line:"第三步"
        }
    },{
        key:"getServiceUUID",
        label:'获取对应属性序号',
        tooltip:"共有512种可选，\
        具体参见‘Https://btprodspecificationrefs.blob.core.windows.net/assigned-numbers/Assigned%20Number%20Types/Assigned_Numbers.pdf’ 的3.8部分",
        valueType:"string",
        params:[{
            key:"e",
            label:"服务名称或编号",
            valueType:["string","number"],
            defaultValue:"apparent_wind_direction"
        }]
    },{
        key:'readChar',
        label:"读取属性为图片，视频等资源",
        params:[{
            key:"a",
            label:"属性",
            valueType:["string","number"],
            defaultValue:""
        }],
        blockOptions:{
            line:'4.属性读写'
        }
    },{
        key:'writeDataURL',
        label:"写入图片视频等资源到属性",
        params:[{
            key:"a",
            label:"属性",
            valueType:["string","number"],
            defaultValue:""
        },{
            key:"e",
            label:"图片或视频或网络直链",
            valueType:"string",
            defaultValue:""
        }]
    },{
        key:'writeText',
        label:"写入文本到属性",
        params:[{
            key:"a",
            label:"属性",
            valueType:["string","number"],
            defaultValue:""
        },{
            key:"e",
            label:"文本",
            valueType:"string",
            defaultValue:" DashedRadius = 114514,不是吗？"
        }]
    }],
    events: [{
        key:"getDevices",
        label:"获取设备成功",
        params:[{
            key:"id",
            label:"设备编号",
            valueType:"string"
        },{
            key:"name",
            label:"设备名",
            valueType:"string"
        }]
    },{
        key:"service_suc",
        label:"服务获取成功",
        params:[]
    },{
        key:"char_suc",
        label:"(每)获取(一个)属性成功",
        params:[{
            key:"chars",
            label:"属性",
            valueType:["string","object","array","number","boolean"]
        }]
    },{
        key:"read",
        label:"读取属性数据成功",
        params:[{
            key:"url",
            label:"数据",
            valueType:"string"
        }]
    }],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        if(!navigator.bluetooth){return;}
        if(!navigator.bluetooth.getAvailability()){return;}
        this.device = undefined;
        this.service = undefined;
        this.server = undefined;
        this.chars = [];
        this.caution = props.caution;
    }

   async  request(){
    try{
      this.device = await navigator.bluetooth.requestDevice({acceptAllDevices:true});
      this.server = this.device.gatt;
      this.emit("getDevices",this.device.id,this.device.name)
    }catch(e){
        this.widgetError("请求有错误，详细信息:"+e.stack)
    }

}

getServiceUUID(e){
    try{
  return BluetoothUUID.getCharacteristic(e)
    }catch(b){
        this.widgetError("蓝牙获取服务错误,具体信息:"+b.message)
    }
}

async cgetService(){
    if(!this.server){return;}
    this.service = await this.server.connect();
    this.emit("service_suc")
}

eject(){if(this.server)this.server.disconnect()}
  
 getChar(a){
    if(typeof a !== "string"&& !this.service)return;
    else{
        try{
       this.chars =  this.service.getCharacteristics();
       this.chars.forEach(value =>{
          this.emit("char_suc",value)
       })
        }catch{
            this.widgetError("在获取特征过程中出错了");
            return;
        }
    }
 }
 
async  readChar(a){
    try{
     if(a.readValue){
        const obj = await a.readValue();//Data View
        const blob = new globalThis.Blob([obj]);
        var fileReader= new globalThis.FileReader();
        fileReader.onload = () =>{this.emit("read",fileReader.result)};
        fileReader.readAsDataURL(blob)
     }
    }catch{
        this.widgetError("由于类型错误,无法读取")
        return
    }
 }

async  writeDataURL(a,e){
    if(a.writeValue&&typeof e === "string"){
        try{
          const res =await  globalThis.fetch(e);
          const value =  res.arrayBuffer();
          a.writeValueWithResponse(value)
        }catch{
            this.widgetError("无法写入资源数据")
        }
    }else{
        this.widgetError("输入类型不正确")
    }
 }
 async  writeText(a,e){
    if(a.writeValue&&typeof e === "string"){
        try{
          const res =new Blob([e])
          const value = await res.arrayBuffer();
          a.writeValueWithResponse(value)
        }catch{
            this.widgetError("无法写入资源数据")
        }
    }else{
        this.widgetError("输入类型不正确")
    }
 }

 set caution(e){
    if(e === types.properties[0].defaultValue){
        return;
    }else{
        this.widgetError("？？注意竟然也改")
    }
 }

 get caution(){
    return types.properties[0].defaultValue
 }
    
}



exports.types = types;
exports.widget = Widget;
