//2023.8.16 ReducedRadius 版权所有。
var globalId = `dr${Math.floor(Math.random()*9e19)}`
var document = globalThis.document
const types = {
    isInvisibleWidget: false,
    type: "TABLE_VISIBLE_WIDGET",
    icon: "icon-widget-table-data",
    title: "表格展示控件",
    version: "1.0.0",
    isGlobalWidget: false,
    properties: [
      {
        key: '__width',
        label: '宽度',
        valueType: 'number',
        defaultValue: 300,
        blockOptions: {
          generateBlock: !1,
        },
      },
      {
        key: '__height',
        label: '高度',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: !1,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },{
        key:"border",
        label:"边框色",
        valueType:"color",
        defaultValue:"#000000"
      },{
        key:"bg",
        label:"背景色",
        valueType:"color",
        defaultValue:"#ffffff"
      },{
        key:"font",
        label:"默认字体色",
        valueType:"color",
        defaultValue:"#000000"
      },{
        key:"_width_",
        label:"边框大小",
        valueType:"number",
        defaultValue:1.2
      },{
        key:"preview",
        label:"控件预览模式",
        valueType:"boolean",
        defaultValue:!0
      },{
        key:"d",
        label:"边框间隔",
        valueType:"boolean",
        defaultValue:!1
      },{
        key:"sie",
        label:"间隔大小",
        valueType:"number",
        defaultValue:2
      }
    ],
    methods: [{
        key:'head',
        label:"添加表格头部",
        params:[{
            key:"l",
            label:"文本",
            valueType:"string",
            defaultValue:""
        },{
            key:"bg",
            label:"背景颜色",
            valueType:"color",
            defaultValue:"#000000"
        },{
            key:"size",
            label:"占用列数",
            valueType:"number",
            defaultValue:2
        },{
            key:"location",
            label:"文本位置",
            valueType:"string",
            defaultValue:"left",
            dropdown:[
                {label:"左侧",value:"left"},
                {label:"右侧",value:"right"},
                {label:"中间",value:"center"}
            ]
        }]
    },{
        key:"addrow",
        label:"添加行",
        params:[{
            key:"text",
            label:"行的内容(每列中间用逗号隔开,)",
            valueType:"string",
            defaultValue:"1,2,3"
        },{
          key:"html",
          label:"允许HTML?",
          valueType:"boolean",
          defaultValue:!0
        }]
    },{
      key:"length",
      label:'获取单元格数量',
      valueType:"number",
      params:[]
    },{
      key:"removeHead",
      label:"删除首个表格头部",
      params:[]
    },{
      key:"removeLine",
      label:"移除第",
      params:[
        {
          key:"line",
          label:"",
          labelAfter:"行",
          valueType:"number",
          defaultValue:1
        }
      ]
    },{
      key:"setObj",
      label:"设置第",
      params:[{
        key:"line",
        label:"",
        labelAfter:"个单元格文本",
        valueType:"number",
        defaultValue:1
      },{
        key:"txt",
        label:"为",
        valueType:"string",
        defaultValue:""
      }]
    },{
      key:"delObj",
      label:"删除第",
      params:[{
        key:"line",
        label:"",
        labelAfter:"个单元格",
        valueType:"number",
        defaultValue:1
      }]
    },{
      key:"append",
      label:"在第",
      params:[{
        key:"line",labelAfter:"行处",label:"",valueType:"number",defaultValue:1
      },{
        key:"con",label:"添加单元格",valueType:"string",defaultValue:"2233"
      }]
    },{
      key:"setProp",
      label:"配置第",
      params:[{
        key:"line",
        label:"",
        labelAfter:"个单元格",
        valueType:"number",
        defaultValue:1
      },{
        key:"location",
        label:"的文本位置为",
        valueType:"string",
        defaultValue:"left",
        dropdown:[
            {label:"左侧",value:"left"},
            {label:"右侧",value:"right"},
            {label:"中间",value:"center"}
        ]
    },{
      key:"edit",
      label:"可编辑为",
      valueType:"boolean",
      defaultValue:!1
    },{
      key:"bg",
      label:"背景色为",
      valueType:"color",
      defaultValue:"#ffffff"
    },{
      key:"br",
      label:"边框色",
      valueType:"color",
      defaultValue:"#00ff00"
    }]
    },{
      key:"getItem",
      label:'获取第',
      valueType:"string",
      params:[{
        key:"line",
        label:"",
        labelAfter:"个单元格的文本",
        valueType:"number",
        defaultValue:1
      }]
    }],
    events: [{
      key:"click",
      label:"的表格被点击",
      params:[]
    },{
      key:'clicks',
      label:"的单元格被点击",
      params:[{
        key:'num',
        label:"序号",
        valueType:"number"
      }]
    },{
      key:"move",
      label:"指针在表格上移动",
      params:[]
    },{
      key:"input",
      label:"可输入单元格改变值",
      params:[{
        key:'num',
        label:"序号",
        valueType:"number"
      },{
        key:"nv",
        label:"新值",
        valueType:"string"
      }]
    }],
  };
  
  class Widget extends VisibleWidget {
    constructor(props) {
      super(props);
      for (let i in props) this[i] = props[i]
    }
    render() {
      return(<table id={globalId} style={{
          borderColor:this.border,
          backgroundColor:this.bg,
          color:this.font,
          borderWidth:this._width_,
          borderStyle:"solid",
          width:"100%",
          height:"100%",
          borderCollapse:this.d?"separate":"collapse",
          borderSpacing:this.sie,
      }}  onClick={()=>this.emit("click")} onMouseMove={this.emit("move")}>
        <thead>
        </thead>
        <tbody>
          <tr hidden={!this.preview}>
            <td style={{border:"1px solid #000"}}>这是一个单元格</td>
            <td style={{border:"1px solid #000"}}><b>粗体</b></td>
          </tr>
        </tbody>
      </table>)
    }

    head(l,bg,size,location){
      var a  = document.createElement("th");
      a.style.backgroundColor = bg;
      a.innerHTML = l;
      a.colSpan = size;
      a.style.textAlign = location
      document.getElementById(globalId).querySelector("thead").appendChild(a)
    }

    addrow(text = "",html = true){
       var a = text.split(",");
       var m = document.createElement("tr");
       a.forEach(e =>{
          var b = document.createElement("td");
          html?b.innerHTML = e:b.innerText = e;
          b.style.borderColor = this.border;
          b.style.borderStyle = "solid";
          var _this = this;
          b.addEventListener("click",async function(){_this.emit("clicks",await _this.calc(this))},{once:false})
          b.addEventListener("input",async function(){_this.emit("input",await _this.calc(this),this.innerText)})
          m.appendChild(b)
       })
       document.getElementById(globalId).querySelector("tbody").appendChild(m)
    }

    length(){
      return document.getElementById(globalId).querySelectorAll("td").length-2
    }

    removeHead(){
      document.getElementById(globalId).querySelector("th").remove()
    }

    removeLine(line){
      if(line <=0||Number(line) == NaN){return this.widgetError("输入错误!")}
      if(document.getElementById(globalId).querySelectorAll("tr")[line])document.getElementById(globalId).querySelectorAll("tr")[line].remove()
    }
   

    setObj(line,txt){
      document.getElementById(globalId).querySelectorAll("td")[line+1].innerHTML = txt
    }

    delObj(line){
      document.getElementById(globalId).querySelectorAll("td")[line+1].remove()
    }

    append(line,con){
      if(document.getElementById(globalId).querySelectorAll("tr")[line]){
        var a = document.createElement("td");
        a.innerText = con;
        a.style.borderColor = this.border;
        a.style.borderStyle = "solid";
        a.style.borderWidth = this._width_;
        a.addEventListener("click",async function(){_this.emit("clicks",await _this.calc(this))},{once:false})
        a.addEventListener("input",async function(){_this.emit("input",await _this.calc(this),this.innerText)})
        document.getElementById(globalId).querySelectorAll("tr")[line].appendChild(a)
      }
    }

    setProp(line,location,edit,bg,br){ 
      const as = document.getElementById(globalId).querySelectorAll("td")[line+1];
  if(as){
     as.contentEditable = edit;
     as.style.textAlign = location;
     as.style.background = bg;
     as.style.borderColor = br;
  }
    }

getItem(line){
  if(document.getElementById(globalId).querySelectorAll("td")[line+1]){return document.getElementById(globalId).querySelectorAll("td")[line+1].innerHTML}
}

calc(element){
return new Promise(e =>{
  document.querySelectorAll("td").forEach((value,number)=>{
     if(value === element){
           e(number-1)
     }
  })
})
}

  }
  
  exports.types = types;
  exports.widget = Widget;
  