function colourRandom() {
  var num = Math.floor(Math.random() * Math.pow(2, 24));
  return '#' + ('00000' + num.toString(16)).substr(-6);
}


var document = this.document;
var window = this.window;
var navigator = this.navigator;
var history = this.history;
const types = {
  isInvisibleWidget: false,
  type: "WIDGET_PLUS_LOCAL_STROAGE",
  icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
  title: "输入框PLUS",
  version: "1.0.0",
  isGlobalWidget: false,
  properties: [
    {
      key: '__width',
      label: '控件宽度',
      valueType: 'number',
      defaultValue: 130,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__height',
      label: '控件高度',
      valueType: 'number',
      defaultValue: 50,
      blockOptions: {
        generateBlock: false,
      },
    },
    {
      key: '__size',
      label: '大小',
      valueType: 'number',
      defaultValue: 0,
      readonly: false,
      blockOptions: {
        setter: {
          keys: ['__height', '__width'],
        },
        getter: {
          keys: ['__height', '__width'],
        },
      },
    },
  ],
  methods: [],
  events: [],
};

class Widget extends VisibleWidget {
  constructor(props) {
    super(props);
    this.__width = props.__width;
    this.__height = props.__height;
    this.pro=props.pro;
  this.color=props.color;
  this.type=props.type;
  this.maxl=props.maxl;
  this.prompt=props.prompt;
  this.value=props.value;
  this.rad=props.rad;
  this.border=props.border;
  this.fontsize=props.fontsize;
  this.ShadowColor=props.ShadowColor;
  this.TXTsh=props.TXTsh;
  this.WIDT=props.WIDT;
  this.CUR=props.CUR;
  this.disa=props.disa;
  this.minl=props.minl;
  this.checked=props.checked;
  this.letterSpacing=props.letterSpacing;
  this.widgetLog('Made By BorderRadius');
  console.log('Made By BorderRadius');

  }
  render() {
    return(
      React.createElement("div", {}, [React.createElement("input", {  onChange: this.onChange.bind(this),
        onLoad: this.onLoad.bind(this),
        onBlur: this.onBlur.bind(this),
        onDoubleClick: this.onDoubleClick.bind(this),
        onFocus: this.onFocus.bind(this),
        onKeyPress: this.onKeyPress.bind(this),
        onKeyUp: this.onKeyUp.bind(this),
        onKeyDown: this.onKeyDown.bind(this),
        onLoad: this.onLoad.bind(this),
        onScroll: this.onscroll.bind(this),
        onSelect: this.onselect.bind(this),
        onMouseMove: this.onmousemove.bind(this),
        onMouseOut: this.onmouseout.bind(this),
        placeholder: (this.prompt),
        maxLength: (this.maxl),
        type: (this.type),
        value: (this.value),
        disabled: (this.disa),
        minLength: (this.minl),
        checked: (this.checked),
        style: {  backgroundColor: (this.pro),
          color: (this.color),
          borderRadius: (this.rad),
          backgroundImage: 'linear-gradient(180deg, rgba(255, 255, 255, 0)0%,#fff 100%)',
          borderColor: (this.border),
          transition: 'all 0.5s linear 1',
          fontSize: (this.fontsize),
          width: "100%",
          height: "100%",
          boxShadow: ('8px 5px 88px 5px' + String(this.ShadowColor)),
          textShadow: ('0px 0px 3px' + String(this.TXTsh)),
          pointerevents: 'auto',
          caretColor: (this.CUR),
          letterSpacing: (this.letterSpacing),
        },
      }, null),])
  );

  }
}

types['properties'].push({
    key: 'color',
    label: '字体颜色',
    valueType: 'color',
    defaultValue: '#000000',
    editorType: '',

})

types['properties'].push({
    key: 'pro',
    label: '背景颜色',
    valueType: 'color',
    defaultValue: '#ffcc33',
    editorType: '',

})

types['properties'].push({
    key: 'border',
    label: '边缘颜色',
    valueType: 'color',
    defaultValue: '#c0c0c0',
    editorType: '',

})

types['properties'].push({
    key: 'ShadowColor',
    label: '背景发光颜色',
    valueType: 'color',
    defaultValue: '#666666',
    editorType: '',

})

types['properties'].push({
    key: 'CUR',
    label: '光标颜色',
    valueType: 'color',
    defaultValue: '#ffcc33',
    editorType: '',

})

types['properties'].push({
    key: 'TXTsh',
    label: '文案发光颜色',
    valueType: 'color',
    defaultValue: '#009900',
    editorType: '',

})

types['properties'].push({
    key: 'maxl',
    label: '最多限制字数',
    valueType: 'number',
    defaultValue: 25,
    editorType: '',

})

types['properties'].push({
    key: 'prompt',
    label: '提示文案',
    valueType: 'string',
    editorType: 'TextArea',
    defaultValue: 'QWQ~点个赞吧',
    editorType: '',

})

types['properties'].push({
    key: 'value',
    label: '值',
    valueType: ['string','number','boolean','array','object',],
    defaultValue: '2233',
    editorType: '',

})

types['properties'].push({
    key: 'rad',
    label: '圆角值',
    valueType: 'number',
    defaultValue: 12,
    editorType: '',

})

types['properties'].push({
    key: 'fontsize',
    label: '字体大小',
    valueType: 'number',
    defaultValue: 3,
    editorType: '',

})

types['properties'].push({
    key: 'disa',
    label: '禁止使用',
    valueType: 'boolean',
    defaultValue: false,
    editorType: '',

})

types['properties'].push({
    key: 'minl',
    label: '最少字符',
    valueType: 'number',
    defaultValue: 1,
    editorType: '',

})

types['properties'].push({
    key: 'checked',
    label: '加载后被自动选中',
    valueType: 'boolean',
    defaultValue: false,
    editorType: '',

})

types['properties'].push({
    key: 'letterSpacing',
    label: '文案间距（允许负数）',
    valueType: 'number',
    defaultValue: 0,
    editorType: '',

})

types['events'].push({
    key: 'onChange',
    label: '内部文案被改变',
    params: [
      {
          key: 'CONTENT',
          label: '文案内容',
          valueType: 'string',
      },],

})
Widget.prototype.onChange = function (event) {
      this.setProps({ 'value': event.target.value });
  this.emit("onChange"  ,event.target.value);
}

types['events'].push({
    key: 'onBlur',
    label: '控件失去焦点',
    params: [],

})
Widget.prototype.onBlur = function (event) {
      this.emit("onBlur");
}

types['events'].push({
    key: 'onDoubleClick',
    label: '被用户双击',
    params: [],

})
Widget.prototype.onDoubleClick = function (event) {
      this.emit("onDoubleClick");
}

types['events'].push({
    key: 'onFocus',
    label: '被用户获取焦点',
    params: [],

})
Widget.prototype.onFocus = function (event) {
      this.emit("onFocus");
}

types['events'].push({
    key: 'onKeyPress',
    label: '敲击键盘',
    params: [],

})
Widget.prototype.onKeyPress = function (event) {
      this.emit("onKeyPress");
}

types['events'].push({
    key: 'onKeyUp',
    label: '释放按键',
    params: [],

})
Widget.prototype.onKeyUp = function (event) {
      this.emit("onKeyUp");
}

types['events'].push({
    key: 'onKeyDown',
    label: '按下按键',
    params: [],

})
Widget.prototype.onKeyDown = function (event) {
      this.emit("onKeyDown");
}

types['events'].push({
    key: 'onLoad',
    label: '获取到信息:网页加载结束',
    params: [],

})
Widget.prototype.onLoad = function (event) {
      this.emit("onLoad");
}

types['events'].push({
    key: 'oninput',
    label: '获得输入',
    params: [],

})
Widget.prototype.oninput = function (event) {
      this.emit("oninput");
}

types['events'].push({
    key: 'onscroll',
    label: '滚动条被滚动',
    params: [],

})
Widget.prototype.onscroll = function (event) {
      this.emit("onscroll");
}

types['events'].push({
    key: 'onselect',
    label: '文案被用户选中',
    params: [],

})
Widget.prototype.onselect = function (event) {
      this.emit("onselect");
}

types['events'].push({
    key: 'onmousemove',
    label: '移到控件前',
    params: [],

})
Widget.prototype.onmousemove = function (event) {
      this.emit("onmousemove");
}
// 强迫症患者的表现(doge)

types['events'].push({
    key: 'onmouseout',
    label: '移出控件',
    params: [],

})
Widget.prototype.onmouseout = function (event) {
      this.emit("onmouseout");
}

types['methods'].push({
    key: 'Type',
    label: '将控件类型设为',
    params: [
      {
          key: 'VALUE',
          label: '值',
          valueType: 'string',
          dropdown: [
    { label: '按钮', value: 'button', },

    { label: '选择框', value: 'checkbox', },

    { label: '颜色', value: 'color', },

    { label: '日期及时间选择', value: 'datetime-local', },

    { label: '密码', value: 'password', },

    { label: '文本', value: 'text', },

    { label: '圆形选择', value: 'radio', },

    { label: '周', value: 'week', },

    { label: '搜索框', value: 'search', },

    { label: '数值', value: 'number', },

    { label: '调节条', value: 'range', },
  ],
      },

],


})
Widget.prototype.Type = function (VALUE,) {
      this.setProps({ 'type': VALUE });

}
types['methods'].push({
    key: 'ALERT',
    label: '弹出警报',
    params: [
      {
          key: 'OBJ',
          label: '内容',
          valueType: 'string',
          defaultValue: "",
      },],


})
Widget.prototype.ALERT = function (OBJ,) {
      window.alert(OBJ);

}
types['methods'].push({
    key: 'DEBUGGER',
    label: '（请加入重复执行）防F12',
    params: [],


})
Widget.prototype.DEBUGGER = function () {
      // awa~你干嘛按F12啊
  // 20221127 2039
  // borderRadius
  debugger
}
types['methods'].push({
    key: 'WINDOW',
    label: '（硬核输入框）弹出窗口并输入',
    params: [
      {
          key: 'va',
          label: '标题',
          valueType: 'string',
          defaultValue: "",
      },],
    valueType: ['string','number','boolean','array','color','object',],

})
Widget.prototype.WINDOW = function (va,) {
      return (window.prompt(va));
}
types['methods'].push({
    key: 'Random',
    label: '返回随机颜色',
    params: [],
    valueType: 'color',
    blockOptions: {
    color: '#33cc00',
    icon: '无',
    generateBlock: true,
    inputsInline: true,
    space: 16,
    tooltip: '看我干嘛',
},
})
Widget.prototype.Random = function () {
      return (colourRandom());
}
exports.types = types;
exports.widget = Widget;
