var Notification = globalThis.Notification;var window = globalThis.window;
const types = {
    isInvisibleWidget: true,
    type: "NOTIFICATION_SENDER_WIDGET",
    icon: "icon-toolbox-feature",
    title: "通知发送",
    version: "1.0.1",
    lastModified:"2023/8/3 12:05",
    author:"ReducedRadius",
    isGlobalWidget: true,
    platforms:["web"],
    properties: [{key:'cansend',label:"能否发送通知？",valueType:"boolean",readonly:true,defaultValue:false},{key:"slient",label:"静音模式",valueType:"boolean",defaultValue:false},{key:'auto',label:'通知驻留',valueType:"boolean",defaultValue:true},
       {
        key:'renotify',
        label:"覆盖时重新通知",
        valueType:"boolean",
        defaultValue:"false"
       }
],
    methods: [{key:'request',label:"请求权限",params:[]},
  {
    key:"close",
    label:"关闭上次通知",
    params:[]
  },{
    key:"create",
    label:"新建通知",
    params:[{
        key:"title",label:"标题",valueType:"string",defaultValue:"Hi!"
    },{key:"body",label:"通知正文",valueType:'string',defaultValue:'欢迎使用ReducedRadius的控件O(∩_∩)O~~'},
   {key:'icon',label:"图标(没有请留空)",valueType:"string",defaultValue:""},
{key:"image",label:"上方显示图像(没有请留空)",valueType:"string",defaultValue:""},
{key:"show",label:"显示时间差值(毫秒,负数为过去几毫秒,正数为将来几毫秒)",valueType:"number",
defaultValue:0}
],
blockOptions:{
    inputsInline:false
}}],
    events: [{key:'click',label:'的通知被点击',params:[]},{key:'close',label:"的通知被关闭",params:[]},{key:'show',label:"的通知出现",params:[]},{
        key:"err",
        label:"展示通知出错",
        params:[]
    }],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
        this.send = props.cansend;
        this.slient = props.slient;
        this.renotify = props.renotify;
        this.auto = Boolean(props.auto)
        this.notification = undefined;
        console.log("By ReducedRadius 2023/8/3")
        if(!Notification){
            this.widgetError("无法使用本控件!")
            return;
        }
    }
    
   get send(){
     if(Notification.permission === "default"||Notification.permission === "denied")return false;
     else{return true}
   }
   
   set send(a){return a;}

   
    request(){
        setTimeout(()=>{
        Notification.requestPermission().then(e =>{
            if(e === "denied"){
                this.widgetError("您已拒绝通知权限")
            }
        })
    },80)
    }

   async create(title="Hi!",body="欢迎使用ReducedRadius的控件O(∩_∩)O~~",icon="",image="",show = 0){
        if(Notification.permission === "default"||Notification.permission === "denied"){
            this.widgetError("还没有请求或者拒绝使用，无法发送通知，请检查通知权限是否打开？");
            return
        }
        if(body === ""){var body = undefined}
        if(icon === ""){var icon = undefined}else{
            try{
               const a = await window.fetch(icon);
               const b = await a.blob();
               if(!b.type.includes("image"))throw new Error("err loading img")
             }catch(e){
                this.widgetWarn("该图片链接可能失效或不可用，通知将不显示图标")
             }
        };
        if(title === ""){this.widgetError("至少不要发一个空的通知吧...");return}
       this.notification = new Notification(title,{
        icon,
        badge:icon,
        body,
        renotify:this.renotify,
        tag:this.renotify?"renotify":undefined,
        requireInteraction:this.auto,
        silent:this.slient,
        lang:'zh-CN',
        image:image === ""?undefined:image,
        show:Date.now()+show
       });
       this.notification.onclick = () =>{this.emit("click")};
       this.notification.onshow = () =>{this.emit("show")};
       this.notification.onclose = () =>{this.emit("close")};
       this.notification.onerror = () =>{this.emit("err")}
    }

    close(){
        if(this.notification)this.notification.close()
    }

}

exports.types = types;
exports.widget = Widget;