/**
 * Copyright 2023/10/3 ReducedRadius.
 */
var document = globalThis.document
const types = {
    isInvisibleWidget: true,
    type: "CURSOR_WIDGET",
    icon: "https://public.coco-central.cn/waddle/2/waddle2.svg",
    title: "鼠标指针控件",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [],
    methods: [{
        key:"setCursor",
        label:"设置鼠标指针样式为",
        params:[{
            key:"tp",
            label:"",
            valueType:"string",
            defaultValue:"auto",
            dropdown:[
                {label:"自动",value:"auto"},
                {label:"箭头",value:"default"},
                {label:"不显示",value:"none"},
                {label:"手指",value:"pointer"},
                {label:"加载中",value:"wait"},
                {label:"帮助",value:"help"},
                {label:"文本选择",value:"text"},
                {label:"垂直文本选择",value:"vertical-text"},
                {label:"禁止",value:"not-allowed"},
            ]
        }]
    },{
        key:"custom",
        label:'自定义鼠标指针',
        params:[{
            key:"url",
            label:"链接",
            valueType:"string",
            defaultValue:"https://blog.yzf.moe/cursor/Arrow.cur"
        },{
            key:"x",
            label:"X坐标偏移",
            valueType:"number",
            defaultValue:0
        },{
            key:"y",
            label:"Y坐标偏移",
            valueType:"number",
            defaultValue:0
        }]
    }],
    events: [],
};

class Widget extends InvisibleWidget {
    constructor(props) {
        super(props);
    }

    setCursor(tp){
        document.documentElement.style.cursor = tp;
    }

    custom(url,x,y){
      document.documentElement.style.cursor = `url(${url}) ${x} ${y},auto`
    }

}

exports.types = types;
exports.widget = Widget;