var document = globalThis.document;
var id = crypto.randomUUID()+"dr"
const types = {
    isInvisibleWidget: false,
    type: "GRADIENT_WIDGET",
    icon: "https://waddle.coco-central.cn/static/img/logo/logo-white.svg",
    title: "渐变配置控件",
    auther:"DashedRadius",
    version: "1.0.0",
    isGlobalWidget: false,
    properties: [
      {
        key: '__width',
        label: '宽度',
        valueType: 'number',
        defaultValue: 200,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__height',
        label: '高度',
        valueType: 'number',
        defaultValue: 123,
        blockOptions: {
          generateBlock: false,
        },
      },
      {
        key: '__size',
        label: '',
        valueType: 'number',
        defaultValue: 0,
        readonly: true,
        blockOptions: {
          setter: {
            keys: ['__height', '__width'],
          },
          getter: {
            keys: ['__height', '__width'],
          },
        },
      },{
        key:"c",
        label:"文本",
        valueType:"string",
        defaultValue:'Made by DashedRadius'
      },{
        key:"r",
        label:"圆角",
        valueType:"number",
        defaultValue:2
      },{
        key:"scale",
        label:"大小",
        valueType:"number",
        defaultValue:100
      },{
        key:"t",
        label:"顺时旋转角度",
        valueType:"number",
        defaultValue:0
      },{
        key:"clip",
        label:"自动剪辑为",
        valueType:"string",
        defaultValue:"none",
        dropdown:[
            {label:"五角星",value:"polygon(50% 2.4%, 34.5% 33.8%, 0% 38.8%, 25% 63.1%, 19.1% 97.6%, 50% 81.3%, 80.9% 97.6%, 75% 63.1%, 100% 38.8%, 65.5% 33.8%)"},
            {label:"圆形",value:"circle()"},
            {label:"心状",value:"path('M15,45 A30,30,0,0,1,75,45 A30,30,0,0,1,135,45 Q135,90,75,130 Q15,90,15,45 Z')"},
            {label:"椭圆",value:"ellipse()"},
            {label:"不剪辑",value:"none"}
        ]
      },{
        key:"bc",
        label:"边缘颜色",
        valueType:'color',
        defaultValue:"#000000"
      }
    ],
    methods: [{
        key:"Linear",
        label:"对方框进行线型渐变",
        params:[{key:"angle",label:"渐变旋转角度",valueType:"number",defaultValue:90},
    {key:"color1",label:"颜色1",valueType:"color",defaultValue:"#ff0000"},
    {key:"per1",label:"颜色1渐变百分比",valueType:"number",defaultValue:0},
    {key:"color2",label:"颜色2",valueType:"color",defaultValue:"#0000ff"},
    {key:"per2",label:"颜色2渐变百分比",valueType:"number",defaultValue:100},
    {key:"add",label:"添加新的渐变?(否则替换当前渐变)",valueType:"boolean",defaultValue:false}],
    blockOptions:{
        inputsInline:false,
        callMethodLabel:false
    }
    },{
        key:"Radial",
        label:"对方框进行弧型渐变",
        params:[{key:"x",label:"原点X坐标百分比",valueType:"number",defaultValue:50},
        {key:"y",label:"原点Y坐标百分比",valueType:"number",defaultValue:50},
        {key:"shape",label:"是否为椭圆渐变?(否则为圆)",valueType:"boolean",defaultValue:false},
    {key:"color1",label:"颜色1",valueType:"color",defaultValue:"#ff0000"},
    {key:"per1",label:"颜色1渐变百分比",valueType:"number",defaultValue:0},
    {key:"color2",label:"颜色2",valueType:"color",defaultValue:"#0000ff"},
    {key:"per2",label:"颜色2渐变百分比",valueType:"number",defaultValue:100},
    {key:"add",label:"添加新的渐变?(否则替换当前渐变)",valueType:"boolean",defaultValue:false}],
    blockOptions:{
        inputsInline:false,
        callMethodLabel:false
    }
    },{
        key:"conic",
        label:"进行矩形渐变",
        params:[{key:"x",label:"初始点X坐标百分比",valueType:"number",defaultValue:50},
        {key:"y",label:"初始点Y坐标百分比",valueType:"number",defaultValue:50},
        {key:"angle",label:"起始角度",valueType:"number",defaultValue:0},
    {key:"color1",label:"颜色1",valueType:"color",defaultValue:"#ff0000"},
    {key:"per1",label:"颜色1渐变角度(360度计)",valueType:"number",defaultValue:0},
    {key:"color2",label:"颜色2",valueType:"color",defaultValue:"#0000ff"},
    {key:"per2",label:"颜色2渐变角度(360度计)",valueType:"number",defaultValue:100},
{key:"add",label:"添加新的渐变?(否则替换当前渐变)",valueType:"boolean",defaultValue:false}],
    blockOptions:{
        inputsInline:false,
        callMethodLabel:false
    }
    },{
        key:"ex",
        label:"不会用?那用示例吧...",
        params:[],
        blockOptions:{
            callMethodLabel:false
        }
    },{
      key:'x',
      label:"裁剪渐变框为文本",
      params:[]
    }
],
    events: [{
        key:"click",
        label:"被点击",
        params:[{key:"a",label:"连击次数",valueType:"number"}]
    }],
  };
  
  class Widget extends VisibleWidget {
    constructor(props) {
      super(props);
      this.__width = props.__width;
      this.__height = props.__height;
      this.r = props.r;
      this.scale = props.scale;
      this.t = props.t;
      this.clip = props.clip;
      this.bc=props.bc;
      this.content = props.c
      this.cliper = props.cliper
    }
    render() {
      return(<div id={id} style={{
        width:this.__width,
        height:this.__height,
        borderRadius:this.r,
        transition:"all 0.3s ease",
        borderStyle:"solid",
        clipPath:this.clip,
        borderColor:this.bc,
        transform:`scale(${this.scale/100}) rotate(${this.t}deg)`
      }} onClick={(event)=>{this.emit("click",event.detail)}} >{this.content}</div>);
    }

    Linear(angle,color1,per1,color2,per2,add){
        if(per1 >100||per1 <0||Number(per1) === NaN){
            this.widgetError("颜色1百分比设定值无效,应为0-100(包括0,100)之间的实数")
            return
        }
       if(per2 >100||per2 <0||Number(per2) === NaN){
        this.widgetError("颜色2百分比设定值无效,应为0-100(包括0,100)之间的实数")
       }
       if(add === false){
      document.getElementById(id).style.background = `linear-gradient(${angle}deg,${color1} ${per1}%,${color2} ${per2}%)`
      document.getElementById(id).style.background === ""?document.getElementById(id).style.background = `-moz-linear-gradient(${angle}deg,${color1},${per1}%,${color2},${per2}%)`:undefined
      document.getElementById(id).style.background === ""?document.getElementById(id).style.background = `-webkit-linear-gradient(${angle}deg,${color1},${per1}%,${color2},${per2}%)`:undefined
       }else{
        if(document.getElementById(id).style.background === ""){document.getElementById(id).style.background = `linear-gradient(${angle}deg,${color1} ${per1}%,${color2} ${per2}%)`}else{
        document.getElementById(id).style.background += `,linear-gradient(${angle}deg,${color1} ${per1}%,${color2} ${per2}%)`
        }
       }
      if(document.getElementById(id).style.background === ""){
        this.widgetError("您的浏览器版本过低,无法使用该功能")
      }
    }

    Radial(x,y,shape,color1,per1,color2,per2,add){
        if(Number(per1) === NaN){
            this.widgetError("颜色1值无效")
            return
        }
       if(Number(per2) === NaN){
        this.widgetError("颜色2值无效")
       }
       if(Number(x) >100||Number(y)>100){
        this.widgetError("参数X或Y过大,不应超过100")
       }
       if(Number(x) <0||Number(y)<0){
        this.widgetError("参数X或Y过小,不应为负数")
       }
       if(add === false){
      document.getElementById(id).style.background = `radial-gradient(${shape?"ellipse":"circle"} at ${x}% ${y}%, ${color1} ${per1}%, ${color2} ${per2}%)`
      document.getElementById(id).style.background === ""?document.getElementById(id).style.background = `-moz-radial-gradient(${shape?"ellipse":"circle"} at ${x}% ${y}%, ${color1} ${per1}%, ${color2} ${per2}%)`:undefined
      document.getElementById(id).style.background === ""?document.getElementById(id).style.background = `-webkit-radial-gradient(${shape?"ellipse":"circle"} at ${x}% ${y}%, ${color1} ${per1}%, ${color2} ${per2}%)`:undefined
       }else{
        if(document.getElementById(id).style.background === ""){document.getElementById(id).style.background = `radial-gradient(${shape?"ellipse":"circle"} at ${x}% ${y}%,${color1} ${per1}%,${color2} ${per2}%)`}else{
        document.getElementById(id).style.background += `,radial-gradient(${shape?"ellipse":"circle"} at ${x}% ${y}%, ${color1} ${per1}%, ${color2} ${per2}%)`}
       }
      if(document.getElementById(id).style.background === ""){
        this.widgetError("您的浏览器版本过低,无法使用该功能")
      }
    }

    conic(x,y,angle,color1,per1,color2,per2,add){
        if(Number(x) >100||Number(y)>100){
            this.widgetError("参数X或Y过大,不应超过100")
           }
           if(Number(x) <0||Number(y)<0){
            this.widgetError("参数X或Y过小,不应为负数")
           }
           if(Number(per1) === NaN){
            this.widgetError("颜色1度数无效")
            return
        }
       if(Number(per2) === NaN){
        this.widgetError("颜色2度数无效")
       }
       if(add === false){
       document.getElementById(id).style.background = `conic-gradient(from ${angle}deg at ${x}% ${y}%, ${color1} ${per1}deg, ${color2} ${per2}deg)`
      document.getElementById(id).style.background === ""?document.getElementById(id).style.background = `-moz-conic-gradient(from ${angle}deg at ${x}% ${y}%, ${color1} ${per1}deg, ${color2} ${per2}deg)`:undefined
      document.getElementById(id).style.background === ""?document.getElementById(id).style.background = `-webkit-conic-gradient(from ${angle}deg at ${x}% ${y}%, ${color1} ${per1}deg, ${color2} ${per2}deg)`:undefined
       }else{
        if(document.getElementById(id).style.background === ""){document.getElementById(id).style.background = `conic-gradient(from ${angle}deg,${color1} ${per1}%,${color2} ${per2}%)`}else{
        document.getElementById(id).style.background += `,conic-gradient(from ${angle}deg at ${x}% ${y}%, ${color1} ${per1}deg, ${color2} ${per2}deg)`}
       }
      if(document.getElementById(id).style.background === ""){
        this.widgetError("您的浏览器版本过低,无法使用该功能")
      }
    }

     ex(){
        document.getElementById(id).style.background = "radial-gradient(ellipse at top, #e66465, transparent),radial-gradient(ellipse at bottom, #4d9f0c, transparent)"
     }
     x(){
      document.getElementById(id).style.webkitBackgroundClip = "text"
      document.getElementById(id).style.backgroundClip = "text"
     }
  }
  
exports.types = types;
exports.widget = Widget;
